/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import com.google.common.base.Preconditions;
import io.dropwizard.testing.ConfigOverride;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.test.util.ConfigurablePrefix;

public class ConfigOverrideExtensionValue
extends ConfigOverride
implements ConfigurablePrefix {
    private static final String DOT = ".";
    private final Logger logger = LoggerFactory.getLogger(ConfigOverrideExtensionValue.class);
    private final ExtensionContext.Namespace namespace;
    private final String storageKey;
    private final String configPath;
    private String prefix;
    private String originalValue;
    private String value;

    public ConfigOverrideExtensionValue(ExtensionContext.Namespace namespace, String storageKey, String configPath) {
        this.namespace = (ExtensionContext.Namespace)Preconditions.checkNotNull((Object)namespace, (Object)"Extension namespace required");
        this.storageKey = (String)Preconditions.checkNotNull((Object)storageKey, (Object)"Storage key required");
        this.configPath = (String)Preconditions.checkNotNull((Object)configPath, (Object)"Configuration path required");
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix.endsWith(DOT) ? prefix : prefix + DOT;
    }

    public void resolveValue(ExtensionContext context) {
        Object res = context.getStore(this.namespace).get((Object)this.storageKey);
        if (res != null) {
            this.value = String.valueOf(res);
        } else {
            this.logger.warn("Configuration override value for '" + this.configPath + "' was not initialized by junit extension (under '" + this.storageKey + "' key). Make sure extensions order is correct.");
            this.value = "";
        }
    }

    public void addToSystemProperties() {
        Preconditions.checkNotNull((Object)this.prefix, (Object)"Prefix is not defined");
        Preconditions.checkNotNull((Object)this.value, (Object)"Value wasn't resolved");
        this.originalValue = System.setProperty(this.prefix + this.configPath, this.value);
    }

    public void removeFromSystemProperties() {
        if (this.originalValue != null) {
            System.setProperty(this.prefix + this.configPath, this.originalValue);
        } else {
            System.clearProperty(this.prefix + this.configPath);
        }
    }
}

