/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.BindingAnnotation;
import com.google.inject.Injector;
import com.google.inject.Key;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.testing.DropwizardTestSupport;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.param.Jit;

public abstract class TestParametersSupport
implements ParameterResolver {
    private final List<Class<?>> supportedClasses = ImmutableList.of(ObjectMapper.class, ClientSupport.class, DropwizardTestSupport.class);

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type;
        Parameter parameter = parameterContext.getParameter();
        if (parameter.getAnnotations().length > 0) {
            if (AnnotationSupport.isAnnotated((AnnotatedElement)parameter, Jit.class)) {
                return true;
            }
            if (!this.isQualifierAnnotation(parameter.getAnnotations())) {
                return false;
            }
        }
        if (Application.class.isAssignableFrom(type = parameter.getType()) || Configuration.class.isAssignableFrom(type)) {
            return true;
        }
        for (Class<?> cls : this.supportedClasses) {
            if (!type.equals(cls)) continue;
            return true;
        }
        return this.getInjector(extensionContext).map(it -> it.getExistingBinding(this.getKey(parameter)) != null).orElse(false);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        Class<?> type = parameter.getType();
        if (ClientSupport.class.equals(type)) {
            return Preconditions.checkNotNull((Object)this.getClient(extensionContext), (Object)"ClientSupport object not available");
        }
        DropwizardTestSupport support = (DropwizardTestSupport)Preconditions.checkNotNull(this.getSupport(extensionContext));
        if (Application.class.isAssignableFrom(type)) {
            return support.getApplication();
        }
        if (ObjectMapper.class.equals(type)) {
            return support.getObjectMapper();
        }
        if (DropwizardTestSupport.class.isAssignableFrom(type)) {
            return support;
        }
        return InjectorLookup.getInjector(support.getApplication()).map(it -> it.getInstance(this.getKey(parameter))).get();
    }

    protected abstract DropwizardTestSupport<?> getSupport(ExtensionContext var1);

    protected abstract ClientSupport getClient(ExtensionContext var1);

    protected abstract Optional<Injector> getInjector(ExtensionContext var1);

    private boolean isQualifierAnnotation(Annotation ... annotations) {
        Annotation ann = annotations[0];
        return annotations.length == 1 && (AnnotationSupport.isAnnotated(ann.annotationType(), javax.inject.Qualifier.class) || AnnotationSupport.isAnnotated(ann.annotationType(), Qualifier.class) || AnnotationSupport.isAnnotated(ann.annotationType(), BindingAnnotation.class));
    }

    private Key<?> getKey(Parameter parameter) {
        Key key = parameter.getAnnotations().length > 0 && !AnnotationSupport.isAnnotated((AnnotatedElement)parameter, Jit.class) ? Key.get((Type)parameter.getParameterizedType(), (Annotation)parameter.getAnnotations()[0]) : Key.get((Type)parameter.getParameterizedType());
        return key;
    }
}

