/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.cmd;

import com.google.inject.Injector;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.YamlConfigurationFactory;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.cli.CheckCommand;
import io.dropwizard.core.cli.Cli;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.cli.ConfiguredCommand;
import io.dropwizard.core.cli.ServerCommand;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.logging.common.LoggingUtil;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.POJOConfigurationFactory;
import io.dropwizard.util.JarLocation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.module.installer.util.InstanceUtils;
import ru.vyarus.dropwizard.guice.test.cmd.CommandResult;
import ru.vyarus.dropwizard.guice.test.util.io.EchoStream;
import ru.vyarus.dropwizard.guice.test.util.io.SystemInMock;

public class CommandTestSupport<C extends Configuration> {
    protected final Class<? extends Application<C>> applicationClass;
    protected final String configPath;
    protected final ConfigurationSourceProvider configSourceProvider;
    protected final Set<ConfigOverride> configOverrides;
    protected final String customPropertyPrefix;
    protected final boolean explicitConfig;
    protected C configuration;
    protected Environment environment;
    protected Injector injector;
    protected Application<C> application;
    protected Bootstrap<C> bootstrap;
    private final PrintStream originalOut = System.out;
    private final PrintStream originalErr = System.err;
    private final InputStream originalIn = System.in;
    private final EchoStream stdOut = new EchoStream(this.originalOut);
    private final EchoStream stdErr = new EchoStream(this.stdOut);
    private final SystemInMock stdIn = new SystemInMock();
    private Cli cli;

    public CommandTestSupport(Class<? extends Application<C>> applicationClass, C configuration) {
        this.applicationClass = applicationClass;
        this.configPath = "";
        this.configSourceProvider = null;
        this.configOverrides = Collections.emptySet();
        this.customPropertyPrefix = null;
        this.configuration = configuration;
        this.explicitConfig = true;
    }

    public CommandTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable ConfigurationSourceProvider configSourceProvider, @Nullable String customPropertyPrefix, ConfigOverride ... configOverrides) {
        this.applicationClass = applicationClass;
        this.configPath = configPath;
        this.configSourceProvider = configSourceProvider;
        this.configOverrides = Optional.ofNullable(configOverrides).map(Set::of).orElse(Set.of());
        this.customPropertyPrefix = customPropertyPrefix;
        this.explicitConfig = false;
    }

    public CommandResult<C> run(String ... args) {
        return this.run((String[])null, args);
    }

    public CommandResult<C> run(@Nullable String[] input, String ... args) {
        if (input != null) {
            this.stdIn.provideText(input);
        }
        CharSequence[] params = this.insertConfigFile(args);
        this.originalOut.println("\n\n" + this.applicationClass.getSimpleName() + " COMMAND: " + String.join((CharSequence)" ", params) + (String)(input == null ? "" : " (with " + input.length + " inputs)"));
        this.originalOut.println("-------------------------------------------------------------------------------------\n");
        Throwable err = null;
        try {
            this.before(params.length > 0 && "server".equals(params[0]));
        }
        catch (Exception ex) {
            err = ex;
        }
        Application<C> app = this.application;
        Command run = null;
        if (params.length > 0) {
            CharSequence name = params[0];
            for (Command cmd : this.bootstrap.getCommands()) {
                if (!cmd.getName().equals(name)) continue;
                run = cmd;
                break;
            }
        }
        if (err == null) {
            err = this.cli.run((String[])params).orElse(null);
        }
        this.reset();
        return new CommandResult<C>(err == null, err, this.stdOut.toString(), this.stdErr.toString(), run, app, this.bootstrap, this.configuration, this.environment, this.injector);
    }

    protected void before(boolean preventServerStart) throws Exception {
        this.applyConfigOverrides();
        System.setOut(new PrintStream((OutputStream)this.stdOut, false, StandardCharsets.UTF_8));
        System.setErr(new PrintStream((OutputStream)this.stdErr, false, StandardCharsets.UTF_8));
        System.setIn(this.stdIn);
        this.application = InstanceUtils.create(this.applicationClass);
        this.bootstrap = new Bootstrap(this.application);
        this.initializeBootstrap(preventServerStart);
        this.cli = new Cli((JarLocation)new DummyJarLocation(), this.bootstrap, (OutputStream)System.out, (OutputStream)System.err);
    }

    protected void reset() {
        this.resetConfigOverrides();
        if (this.configuration != null) {
            this.configuration.getLoggingFactory().reset();
        } else {
            LoggingUtil.getLoggerContext().getLogger("ROOT").detachAndStopAllAppenders();
        }
        this.application = null;
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
        System.setIn(this.originalIn);
    }

    private void applyConfigOverrides() {
        this.configOverrides.forEach(ConfigOverride::addToSystemProperties);
    }

    private void resetConfigOverrides() {
        this.configOverrides.forEach(ConfigOverride::removeFromSystemProperties);
    }

    private void initializeBootstrap(final boolean preventServerStart) {
        this.bootstrap.addCommand((ConfiguredCommand)new ServerCommand(this.application));
        this.bootstrap.addCommand((ConfiguredCommand)new CheckCommand(this.application));
        this.application.initialize(this.bootstrap);
        this.bootstrap.addBundle(new ConfiguredBundle<C>(){

            public void run(C configuration, Environment environment) {
                CommandTestSupport.this.environment = environment;
                CommandTestSupport.this.injector = InjectorLookup.getInjector(environment).orElse(null);
                if (preventServerStart) {
                    environment.lifecycle().addServerLifecycleListener(server -> {
                        throw new IllegalStateException("Application was expected to fail on startup, but successfully started instead");
                    });
                }
            }
        });
        if (this.configSourceProvider != null) {
            this.bootstrap.setConfigurationSourceProvider(this.configSourceProvider);
        }
        if (this.explicitConfig) {
            this.bootstrap.setConfigurationFactoryFactory((klass, validator, objectMapper, propertyPrefix) -> new POJOConfigurationFactory(this.configuration));
        } else if (this.customPropertyPrefix != null) {
            String prefix = this.customPropertyPrefix;
            this.bootstrap.setConfigurationFactoryFactory((klass, validator, objectMapper, propertyPrefix) -> new ConfigInterceptor<Configuration>((ConfigurationFactory<Configuration>)new YamlConfigurationFactory(klass, validator, objectMapper, prefix), c -> {
                this.configuration = c;
            }));
        }
    }

    private String[] insertConfigFile(String ... args) {
        String[] params = args;
        if (this.configPath != null && args.length > 0) {
            params = new String[args.length + 1];
            params[0] = args[0];
            params[1] = this.configPath;
            if (args.length > 1) {
                System.arraycopy(args, 2, params, 1, args.length);
            }
        }
        return params;
    }

    private static class DummyJarLocation
    extends JarLocation {
        DummyJarLocation() {
            super(CommandTestSupport.class);
        }

        public Optional<String> getVersion() {
            return Optional.of("1.0.0");
        }
    }

    private static class ConfigInterceptor<C extends Configuration>
    implements ConfigurationFactory<C> {
        private final ConfigurationFactory<C> realFactory;
        private final Consumer<C> action;

        ConfigInterceptor(ConfigurationFactory<C> realFactory, Consumer<C> action) {
            this.realFactory = realFactory;
            this.action = action;
        }

        public C build(ConfigurationSourceProvider provider, String path) throws IOException, ConfigurationException {
            Configuration res = (Configuration)this.realFactory.build(provider, path);
            this.action.accept(res);
            return (C)res;
        }

        public C build() throws IOException, ConfigurationException {
            Configuration res = (Configuration)this.realFactory.build();
            this.action.accept(res);
            return (C)res;
        }
    }
}

