/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import io.dropwizard.core.setup.Bootstrap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;

public final class BundleSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleSupport.class);

    private BundleSupport() {
    }

    public static void initBundles(ConfigurationContext context) {
        List<GuiceyBundle> bundles = context.getEnabledBundles();
        GuiceyBootstrap guiceyBootstrap = new GuiceyBootstrap(context, bundles);
        for (GuiceyBundle bundle : new ArrayList<GuiceyBundle>(bundles)) {
            BundleSupport.initBundle(Collections.emptyList(), bundle, bundles, context, guiceyBootstrap);
        }
        context.lifecycle().bundlesInitialized(context.getEnabledBundles(), context.getDisabledBundles(), context.getIgnoredItems(ConfigItem.Bundle));
    }

    public static void runBundles(ConfigurationContext context) throws Exception {
        GuiceyEnvironment env = new GuiceyEnvironment(context);
        for (GuiceyBundle bundle : context.getEnabledBundles()) {
            bundle.run(env);
        }
        context.lifecycle().bundlesStarted(context.getEnabledBundles());
    }

    public static <T> List<T> removeDuplicates(List<T> list) {
        ArrayList registered = Lists.newArrayList();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            Class<?> type = it.next().getClass();
            if (registered.contains(type)) {
                it.remove();
                continue;
            }
            registered.add(type);
        }
        return list;
    }

    public static <T> List<T> removeTypes(List<T> list, List<Class<? extends T>> filter) {
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            Class<?> type = it.next().getClass();
            if (!filter.contains(type)) continue;
            it.remove();
        }
        return list;
    }

    public static <T> List<T> findBundles(Bootstrap bootstrap, Class<T> type) {
        ArrayList bundles = Lists.newArrayList(BundleSupport.resolveBundles(bootstrap, "configuredBundles"));
        bundles.removeIf(o -> !type.isAssignableFrom(o.getClass()));
        return bundles;
    }

    private static void initBundle(List<Class<? extends GuiceyBundle>> path, GuiceyBundle bundle, List<GuiceyBundle> wrk, ConfigurationContext context, GuiceyBootstrap bootstrap) {
        wrk.clear();
        Class<?> bundleType = bundle.getClass();
        if (path.contains(bundleType)) {
            String name = bundleType.getSimpleName();
            throw new IllegalStateException(String.format("Bundles registration loop detected: %s ) -> %s ...", path.stream().map(Class::getSimpleName).collect(Collectors.joining(" -> ")).replace(name, "( " + name), name));
        }
        LOGGER.debug("Initializing bundle ({} level): {}", (Object)(path.size() + 1), (Object)bundleType.getName());
        ItemId id = ItemId.from(bundle);
        if (context.isBundleEnabled(id)) {
            context.openScope(id);
            bundle.initialize(bootstrap);
            context.closeScope();
        }
        if (!wrk.isEmpty()) {
            ArrayList<Class<? extends GuiceyBundle>> nextPath = new ArrayList<Class<? extends GuiceyBundle>>(path);
            nextPath.add(bundleType);
            for (GuiceyBundle nextBundle : new ArrayList<GuiceyBundle>(wrk)) {
                BundleSupport.initBundle(nextPath, nextBundle, wrk, context, bootstrap);
            }
        }
    }

    private static <T> List<T> resolveBundles(Bootstrap bootstrap, String field) {
        try {
            Field declaredField = Bootstrap.class.getDeclaredField(field);
            declaredField.setAccessible(true);
            List res = (List)declaredField.get(bootstrap);
            declaredField.setAccessible(false);
            return (List)MoreObjects.firstNonNull((Object)res, Collections.emptyList());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve bootstrap field " + field, e);
        }
    }
}

