/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.scanner.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class OReflectionHelper {
    private static final String CLASS_EXTENSION = ".class";

    private OReflectionHelper() {
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
    public static List<Class<?>> getClassesFor(String iPackageName, ClassLoader iClassLoader) throws ClassNotFoundException {
        String className;
        Class<?> cls;
        ArrayList<File> directories;
        ArrayList classes;
        block13: {
            classes = new ArrayList();
            directories = new ArrayList<File>();
            try {
                String packageUrl = iPackageName.replace('.', '/');
                Enumeration<URL> resources = iClassLoader.getResources(packageUrl);
                if (!resources.hasMoreElements()) {
                    resources = iClassLoader.getResources(packageUrl + CLASS_EXTENSION);
                    if (resources.hasMoreElements()) {
                        throw new IllegalArgumentException(iPackageName + " does not appear to be a valid package but a class");
                    }
                    break block13;
                }
                while (resources.hasMoreElements()) {
                    URL res = resources.nextElement();
                    if ("jar".equalsIgnoreCase(res.getProtocol())) {
                        JarURLConnection conn = (JarURLConnection)res.openConnection();
                        JarFile jar = conn.getJarFile();
                        for (JarEntry e : Collections.list(jar.entries())) {
                            if (!e.getName().startsWith(iPackageName.replace('.', '/')) || !e.getName().endsWith(CLASS_EXTENSION) || !OReflectionHelper.isAcceptibleClass(cls = Class.forName(className = e.getName().replace("/", ".").substring(0, e.getName().length() - 6), true, iClassLoader))) continue;
                            classes.add(cls);
                        }
                        continue;
                    }
                    directories.add(new File(URLDecoder.decode(res.getPath(), "UTF-8")));
                }
            }
            catch (NullPointerException x) {
                throw new ClassNotFoundException(iPackageName + " does not appear to be a valid package (Null pointer exception)");
            }
            catch (UnsupportedEncodingException encex) {
                throw new ClassNotFoundException(iPackageName + " does not appear to be a valid package (Unsupported encoding)");
            }
            catch (IOException ioex) {
                throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + iPackageName);
            }
        }
        for (File directory : directories) {
            if (directory.exists()) {
                File[] files = directory.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    if (file.isDirectory()) {
                        classes.addAll(OReflectionHelper.findClasses(file, iPackageName, iClassLoader));
                        continue;
                    }
                    if (!file.getName().endsWith(CLASS_EXTENSION) || !OReflectionHelper.isAcceptibleClass(cls = Class.forName(iPackageName + "." + (className = file.getName().substring(0, file.getName().length() - CLASS_EXTENSION.length())), true, iClassLoader))) continue;
                    classes.add(cls);
                }
                continue;
            }
            throw new ClassNotFoundException(iPackageName + " (" + directory.getPath() + ") does not appear to be a valid package");
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File iDirectory, String iPackageName, ClassLoader iClassLoader) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!iDirectory.exists()) {
            return classes;
        }
        iPackageName = (String)iPackageName + "." + iDirectory.getName();
        File[] files = iDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                String className;
                Class<?> cls;
                if (file.isDirectory()) {
                    if (file.getName().contains(".")) continue;
                    classes.addAll(OReflectionHelper.findClasses(file, (String)iPackageName, iClassLoader));
                    continue;
                }
                if (!file.getName().endsWith(CLASS_EXTENSION) || !OReflectionHelper.isAcceptibleClass(cls = Class.forName((String)iPackageName + "." + (className = file.getName().substring(0, file.getName().length() - CLASS_EXTENSION.length())), true, iClassLoader))) continue;
                classes.add(cls);
            }
        }
        return classes;
    }

    private static boolean isAcceptibleClass(Class type) {
        return Modifier.isPublic(type.getModifiers());
    }
}

