/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.web.listener;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.lifecycle.Managed;
import java.util.EventListener;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.session.SessionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.listener.WebListenerInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;

public class SessionListenersSupport
implements Managed {
    private final Logger logger = LoggerFactory.getLogger(WebListenerInstaller.class);
    private final boolean failWithoutSession;
    private final Multimap<MutableServletContextHandler, EventListener> listeners = LinkedListMultimap.create();

    public SessionListenersSupport(boolean failWithoutSession) {
        this.failWithoutSession = failWithoutSession;
    }

    public void add(MutableServletContextHandler environment, EventListener listener) {
        this.listeners.put((Object)environment, (Object)listener);
    }

    public void start() throws Exception {
        for (MutableServletContextHandler environment : this.listeners.keySet()) {
            SessionHandler sessionHandler = environment.getSessionHandler();
            if (sessionHandler == null) {
                String msg = String.format("Can't register session listeners for %s because sessions support is not enabled: %s", environment.getDisplayName().toLowerCase(), Joiner.on((char)',').join((Iterable)this.listeners.get((Object)environment).stream().map(it -> FeatureUtils.getInstanceClass(it).getSimpleName()).collect(Collectors.toList())));
                if (this.failWithoutSession) {
                    throw new IllegalStateException(msg);
                }
                this.logger.warn(msg);
                continue;
            }
            this.listeners.get((Object)environment).forEach(arg_0 -> ((SessionHandler)sessionHandler).addEventListener(arg_0));
        }
    }

    public void stop() throws Exception {
    }
}

