/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import ru.vyarus.dropwizard.guice.debug.report.jersey.util.ProviderRenderUtil;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider.JerseyProviderInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class ProviderReporter
extends Reporter {
    private final Multimap<Class, String> prerender = HashMultimap.create();

    public ProviderReporter() {
        super(JerseyProviderInstaller.class, "providers = ");
    }

    public ProviderReporter provider(Class<?> provider, boolean isHkManaged, boolean isLazy) {
        for (Class ext : ProviderRenderUtil.detectProviderTypes(provider)) {
            this.prerender.put((Object)ext, (Object)ProviderRenderUtil.render(ext, provider, isHkManaged, isLazy));
        }
        return this;
    }

    @Override
    public void report() {
        for (Class cls : this.prerender.keySet()) {
            this.reportGroup(ProviderRenderUtil.getTypeName(cls), this.prerender.get((Object)cls));
        }
        super.report();
    }

    private void printAll(Collection<String> lines) {
        for (String line : lines) {
            this.line("    " + line, new Object[0]);
        }
    }

    private void reportGroup(String title, Collection<String> items) {
        if (!items.isEmpty()) {
            this.separate();
            this.line(title, new Object[0]);
            this.printAll(items);
        }
    }
}

