/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.option;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.option.OptionsConfig;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.option.OptionsInfo;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class OptionsRenderer
implements ReportRenderer<OptionsConfig> {
    private static final String POSTFIX = "Options";
    private final GuiceyConfigurationInfo info;

    public OptionsRenderer(GuiceyConfigurationInfo info) {
        this.info = info;
    }

    @Override
    public String renderReport(OptionsConfig config) {
        StringBuilder res = new StringBuilder();
        this.render(config, res);
        return res.toString();
    }

    private void render(OptionsConfig config, StringBuilder res) {
        List<Class<Enum>> groups = this.info.getOptions().getOptionGroups();
        groups.removeAll(config.getHiddenGroups());
        for (Class<Enum> group : groups) {
            String optionsRender = this.renderOptions(group, config);
            if (optionsRender.isEmpty()) continue;
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append(String.format("%-25s (%s)", this.groupName(group), RenderUtils.renderClass(group))).append(Reporter.NEWLINE).append(optionsRender);
        }
    }

    private String renderOptions(Class<Enum> group, OptionsConfig config) {
        StringBuilder res = new StringBuilder();
        ArrayList markers = Lists.newArrayList();
        for (Enum option : group.getEnumConstants()) {
            OptionsInfo options = this.info.getOptions();
            if (this.isHidden(option, config)) continue;
            markers.clear();
            if (config.isShowNotDefinedOptions() && options.isSet(option)) {
                markers.add("CUSTOM");
            }
            if (config.isShowNotUsedMarker() && !options.isUsed(option)) {
                markers.add("NOT_USED");
            }
            res.append("    ").append("    ").append(String.format("%-30s = %-30s %s", option.name(), this.valueToString(options.getValue(option)), RenderUtils.markers(markers))).append(Reporter.NEWLINE);
        }
        return res.toString();
    }

    private String groupName(Class<Enum> group) {
        String name = group.getSimpleName();
        if (name.endsWith(POSTFIX)) {
            name = name.substring(0, name.length() - POSTFIX.length());
        }
        return name;
    }

    private boolean isHidden(Enum option, OptionsConfig config) {
        return config.getHiddenOptions().contains(option) || !this.info.getOptions().knowsOption(option) || !config.isShowNotDefinedOptions() && !this.info.getOptions().isSet(option);
    }

    private String valueToString(Object value) {
        Class<?> type;
        Object res = value == null ? "null" : ((type = value.getClass()).isArray() ? Arrays.deepToString((Object[])value) : (Iterable.class.isAssignableFrom(type) ? "[" + Joiner.on((String)", ").join((Iterable)value) + "]" : value.toString()));
        return res;
    }
}

