/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InterceptorBinding;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInterceptor;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceAopConfig;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.ModuleDeclaration;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelParser;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelUtils;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.debug.util.TreeNode;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.map.IgnoreGenericsMap;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
public class GuiceAopMapRenderer
implements ReportRenderer<GuiceAopConfig> {
    private final Injector injector;
    private final List<Module> modules;

    public GuiceAopMapRenderer(Injector injector) {
        this.injector = injector;
        GuiceyConfigurationInfo info = (GuiceyConfigurationInfo)injector.getInstance(GuiceyConfigurationInfo.class);
        this.modules = info.getModuleIds().stream().map(it -> (Module)((ModuleItemInfo)info.getData().getInfo((ItemId)it)).getInstance()).collect(Collectors.toList());
    }

    @Override
    public String renderReport(GuiceAopConfig config) {
        List guiceManagedObjects;
        List<AopDeclaration> tree;
        StringBuilder res = new StringBuilder();
        List declared = Elements.getElements((Stage)Stage.TOOL, this.modules).stream().filter(it -> it instanceof InterceptorBinding).collect(Collectors.toList());
        if (!config.isHideDeclarationsBlock()) {
            List<ModuleDeclaration> declarationModules = GuiceModelParser.parse(this.injector, declared);
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE);
            this.renderDeclared(declarationModules, res);
        }
        if (!declared.isEmpty() && !(tree = this.filter(GuiceModelParser.parse(this.injector, guiceManagedObjects = this.injector.getAllBindings().values().stream().filter(it -> it instanceof ConstructorBinding).collect(Collectors.toList())), config)).isEmpty()) {
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE);
            this.renderMap(tree, res);
        }
        return res.toString();
    }

    private void renderDeclared(List<ModuleDeclaration> declarations, StringBuilder res) {
        ArrayList lines = new ArrayList();
        GuiceModelUtils.visitBindings(declarations, it -> lines.add(String.format("%-70s    at %s", it.getModule().substring(it.getModule().lastIndexOf(46) + 1) + "/" + RenderUtils.getClassName(it.getSpecial().get(0).getClass()), it.getSource())));
        lines.sort(Comparator.naturalOrder());
        TreeNode root = new TreeNode("%s AOP handlers declared", lines.size());
        for (String line : lines) {
            root.child(line, new Object[0]);
        }
        root.render(res);
    }

    private void renderMap(List<AopDeclaration> declarations, StringBuilder res) {
        if (!declarations.isEmpty()) {
            TreeNode root = new TreeNode("%s bindings affected by AOP", declarations.size());
            for (AopDeclaration dec : declarations) {
                TreeNode decl = root.child(GuiceModelUtils.renderKey(dec.getKey()) + "    (" + RenderUtils.renderPackage(dec.getKey().getTypeLiteral().getRawType()) + ")", new Object[0]);
                for (Map.Entry<Method, List<Class<? extends MethodInterceptor>>> entry : dec.getInterceptors().entrySet()) {
                    Method method = entry.getKey();
                    List<Class<? extends MethodInterceptor>> handlers = entry.getValue();
                    String warn = "";
                    if (method.isSynthetic()) {
                        warn = "[SYNTHETIC] ";
                    }
                    Object methodName = TypeToStringUtils.toStringMethod((Method)method, (Map)IgnoreGenericsMap.getInstance());
                    methodName = warn + ((String)methodName).substring(((String)methodName).indexOf(method.getName()));
                    decl.child("%-60s      %s", methodName, handlers.stream().map(RenderUtils::getClassName).collect(Collectors.joining(", ")));
                }
            }
            root.render(res);
        }
    }

    private List<AopDeclaration> filter(List<ModuleDeclaration> modules, GuiceAopConfig config) {
        ArrayList<AopDeclaration> res = new ArrayList<AopDeclaration>();
        GuiceModelUtils.visitBindings(modules, it -> {
            Class type = it.getKey().getTypeLiteral().getRawType();
            if (config.getTypeMatcher() != null && !config.getTypeMatcher().matches((Object)type)) {
                return;
            }
            AopDeclaration dec = new AopDeclaration(it.getKey());
            Map interceptors = ((ConstructorBinding)it.getElement()).getMethodInterceptors();
            for (Map.Entry entry : interceptors.entrySet()) {
                Method method = (Method)entry.getKey();
                if (config.getMethodMatcher() != null && !config.getMethodMatcher().matches((Object)method)) continue;
                List handlers = ((List)entry.getValue()).stream().map(Object::getClass).collect(Collectors.toList());
                if (!config.getShowOnly().isEmpty() && Collections.disjoint(config.getShowOnly(), handlers)) continue;
                dec.getInterceptors().put(method, handlers);
            }
            if (!dec.getInterceptors().isEmpty()) {
                res.add(dec);
            }
        });
        res.sort(Comparator.comparing(it -> it.getKey().getTypeLiteral().getRawType().getSimpleName()));
        return res;
    }

    private static class AopDeclaration {
        private final Key key;
        private final Map<Method, List<Class<? extends MethodInterceptor>>> interceptors = new TreeMap<Method, List<Class<? extends MethodInterceptor>>>(Comparator.comparing(Method::getName).thenComparing(Method::getParameterCount).thenComparing(it -> it.getParameterTypes().length == 0 ? "A" : it.getParameterTypes()[0].getSimpleName()));

        AopDeclaration(Key key) {
            this.key = key;
        }

        protected Key getKey() {
            return this.key;
        }

        protected Map<Method, List<Class<? extends MethodInterceptor>>> getInterceptors() {
            return this.interceptors;
        }
    }
}

