/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zul.AbstractGroupsModel;
import org.zkoss.zul.GroupComparator;
import org.zkoss.zul.ext.GroupsSortableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsModelArray<D, H, F, E>
extends AbstractGroupsModel<D, H, F, E>
implements GroupsSortableModel<D>,
ComponentCloneListener,
Cloneable {
    protected D[] _nativedata;
    protected Comparator<D> _comparator;
    protected D[][] _data;
    protected Object[] _heads;
    protected Object[] _foots;
    protected boolean[] _opens;

    public GroupsModelArray(D[] data, Comparator<D> cmpr) {
        this(data, cmpr, 0);
    }

    public GroupsModelArray(D[] data, Comparator<D> cmpr, int col) {
        this(data, cmpr, col, true);
    }

    public GroupsModelArray(D[] data, Comparator<D> cmpr, int col, boolean clone) {
        if (data == null || cmpr == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this._nativedata = clone ? ArraysX.duplicate((Object[])data) : data;
        this._comparator = cmpr;
        this.group(this._comparator, true, col);
    }

    public GroupsModelArray(List<D> data, Comparator cmpr, int col) {
        this(data.toArray(), cmpr, col, false);
    }

    public GroupsModelArray(List<D> data, Comparator cmpr) {
        this(data, cmpr, 0);
    }

    @Override
    public D getChild(int groupIndex, int index) {
        return this._data[groupIndex][index];
    }

    @Override
    public int getChildCount(int groupIndex) {
        return this._data[groupIndex].length;
    }

    @Override
    public H getGroup(int groupIndex) {
        return (H)this._heads[groupIndex];
    }

    @Override
    public int getGroupCount() {
        return this._data.length;
    }

    @Override
    public F getGroupfoot(int groupIndex) {
        return (F)this._foots[groupIndex];
    }

    @Override
    public boolean hasGroupfoot(int groupIndex) {
        return this._foots == null ? false : this._foots[groupIndex] != null;
    }

    @Override
    public void sort(Comparator<D> cmpr, boolean ascending, int col) {
        this.sortAllGroupData(cmpr, ascending, col);
        this.fireEvent(3, -1, -1, -1);
    }

    @Override
    public void group(final Comparator<D> cmpr, boolean ascending, int col) {
        Comparator cmprx = cmpr instanceof GroupComparator ? new Comparator<D>(){

            @Override
            public int compare(D o1, D o2) {
                return ((GroupComparator)cmpr).compareGroup(o1, o2);
            }
        } : cmpr;
        this.sortDataInGroupOrder(cmprx, ascending, col);
        this.organizeGroup(cmprx, col);
        if (cmprx != cmpr) {
            this.sortAllGroupData(cmpr, ascending, col);
        }
        this.fireEvent(7, -1, -1, -1);
    }

    public boolean isClose(int groupIndex) {
        return !this.isGroupOpened(groupIndex);
    }

    public void setClose(int groupIndex, boolean close) {
        this.setOpenGroup0(groupIndex, !close);
    }

    @Override
    public boolean addOpenGroup(int groupIndex) {
        return this.setOpenGroup0(groupIndex, true);
    }

    @Override
    public boolean removeOpenGroup(int groupIndex) {
        return this.setOpenGroup0(groupIndex, false);
    }

    private boolean setOpenGroup0(int groupIndex, boolean open) {
        if (this._opens == null) {
            if (open) {
                return true;
            }
            int length = this.getGroupCount();
            this._opens = new boolean[length];
            for (int i = 0; i < length; ++i) {
                this._opens[i] = true;
            }
        }
        if (this._opens[groupIndex] != open) {
            this._opens[groupIndex] = open;
            this.fireEvent(10, groupIndex, groupIndex, groupIndex);
            return true;
        }
        return false;
    }

    @Override
    public boolean isGroupOpened(int groupIndex) {
        return this._opens == null || this._opens[groupIndex];
    }

    private void sortAllGroupData(Comparator<D> cmpr, boolean ascending, int col) {
        for (int i = 0; i < this._data.length; ++i) {
            this.sortGroupData(this.getGroup(i), this._data[i], cmpr, ascending, col);
        }
    }

    protected void sortGroupData(H group, D[] groupdata, Comparator<D> cmpr, boolean ascending, int col) {
        Arrays.sort(groupdata, cmpr);
    }

    protected void organizeGroup(Comparator<D> cmpr, int col) {
        LinkedList group = new LinkedList();
        List gdata = null;
        Object last = null;
        Object curr = null;
        for (int i = 0; i < this._nativedata.length; ++i) {
            curr = this._nativedata[i];
            if (last == null || cmpr.compare(last, curr) != 0) {
                gdata = new LinkedList<Object>();
                group.add(gdata);
            }
            gdata.add(curr);
            last = this._nativedata[i];
        }
        List[] gd = new List[group.size()];
        group.toArray(gd);
        Class<?> classD = this._nativedata.getClass().getComponentType();
        this._data = (Object[][])Array.newInstance(classD, gd.length, 0);
        this._foots = new Object[gd.length];
        this._heads = new Object[gd.length];
        this._opens = new boolean[this._data.length];
        for (int i = 0; i < gd.length; ++i) {
            gdata = gd[i];
            this._data[i] = (Object[])Array.newInstance(classD, gdata.size());
            gdata.toArray(this._data[i]);
            this._heads[i] = this.createGroupHead(this._data[i], i, col);
            this._foots[i] = this.createGroupFoot(this._data[i], i, col);
            this._opens[i] = this.createGroupOpen(this._data[i], i, col);
        }
    }

    protected H createGroupHead(D[] groupdata, int index, int col) {
        D o = groupdata[0];
        return (H)(o != null && o.getClass().isArray() && col < Array.getLength(o) ? Array.get(o, col) : o);
    }

    protected F createGroupFoot(D[] groupdata, int index, int col) {
        return null;
    }

    protected void sortDataInGroupOrder(Comparator<D> cmpr, boolean ascending, int colIndex) {
        Arrays.sort(this._nativedata, cmpr);
    }

    protected boolean createGroupOpen(D[] groupdata, int index, int col) {
        return true;
    }

    @Override
    public Object clone() {
        GroupsModelArray clone = (GroupsModelArray)super.clone();
        if (this._nativedata != null) {
            clone._nativedata = ArraysX.duplicate((Object[])this._nativedata);
        }
        if (this._data != null) {
            clone._data = (Object[][])ArraysX.duplicate(this._data);
        }
        if (this._heads != null) {
            clone._heads = ArraysX.duplicate((Object[])this._heads);
        }
        if (this._foots != null) {
            clone._foots = ArraysX.duplicate((Object[])this._foots);
        }
        if (this._opens != null) {
            clone._opens = (boolean[])ArraysX.duplicate((Object)this._opens);
        }
        return clone;
    }

    public Object willClone(Component comp) {
        return this.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GroupsModelArray) {
            return Arrays.equals(this._nativedata, ((GroupsModelArray)o)._nativedata);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this._nativedata);
    }

    public String toString() {
        return Objects.toString(this._nativedata);
    }
}

