/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import org.zkoss.zk.ui.ArithmeticWrongValueException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Doublebox
extends NumberInputElement {
    private static HashMap<String, PropertyAccess> _properties = new HashMap(1);

    public Doublebox() {
        this.setCols(11);
    }

    public Doublebox(double value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public Doublebox(Double value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public Double getValue() throws WrongValueException {
        return (Double)this.getTargetValue();
    }

    public double doubleValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (Double)val : 0.0;
    }

    public int intValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? ((Double)val).intValue() : 0;
    }

    public long longValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? ((Double)val).longValue() : 0L;
    }

    public short shortValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? ((Double)val).shortValue() : (short)0;
    }

    public void setValue(Double value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public void setValue(double value) throws WrongValueException {
        this.setValue(new Double(value));
    }

    public String getZclass() {
        return this._zclass == null ? "z-doublebox" : this._zclass;
    }

    public Object unmarshall(Object value) {
        return value instanceof Number ? new Double(((Number)value).doubleValue()) : value;
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            int divscale;
            double v = Double.parseDouble(val);
            int n = divscale = vals[1] != null ? (Integer)vals[1] : 0;
            if (divscale > 0) {
                v /= Math.pow(10.0, divscale);
            }
            return new Double(v);
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    protected String coerceToString(Object value) {
        try {
            return value != null && this.getFormat() == null ? (value instanceof Double ? Doublebox.toLocaleString((Double)value, this.getDefaultLocale()) : value.toString()) : this.formatNumber(value, null);
        }
        catch (ArithmeticException ex) {
            throw new ArithmeticWrongValueException((Component)this, ex.getMessage(), (Throwable)ex, value);
        }
    }

    static String toLocaleString(Double v, Locale locale) {
        DecimalFormat df = new DecimalFormat("#.#");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        char DECIMAL = symbols.getDecimalSeparator();
        char MINUS = symbols.getMinusSign();
        return df.format(v).toString().replace('.', DECIMAL).replace('-', MINUS);
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    static {
        _properties.put("value", (PropertyAccess)new PropertyAccess<Double>(){

            public void setValue(Component cmp, Double value) {
                ((Doublebox)cmp).setValue(value);
            }

            public Class<Double> getType() {
                return Double.class;
            }

            public Double getValue(Component cmp) {
                return ((Doublebox)cmp).getValue();
            }
        });
    }
}

