/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.JVMs;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.math.RoundingModes;
import org.zkoss.util.Locales;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.ObjectPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zul.impl.FormatInputElement;

public abstract class NumberInputElement
extends FormatInputElement {
    private int _rounding = 6;
    private Locale _locale;
    private static HashMap<String, PropertyAccess> _properties = new HashMap(2);

    public void setRoundingMode(int mode) {
        if (this._rounding != mode) {
            if (!JVMs.isJava6()) {
                throw new UnsupportedOperationException("Java 6 or above is required");
            }
            this._rounding = mode;
            this.smartUpdate("rounding", mode);
        }
    }

    public void setRoundingMode(String name) {
        this.setRoundingMode(RoundingModes.valueOf((String)name));
    }

    public int getRoundingMode() {
        return this._rounding;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        if (!Objects.equals((Object)this._locale, (Object)locale)) {
            this._locale = locale;
            if (this.getFormat() == null) {
                this.setFormat(this.getDefaultFormat());
            }
            this.invalidate();
        }
    }

    public void setLocale(String locale) {
        this.setLocale(locale != null && locale.length() > 0 ? Locales.getLocale((String)locale) : null);
    }

    private String getRealSymbols() {
        if (this._locale != null) {
            String localeName = this._locale.toString();
            if (Utils.markClientInfoPerDesktop((Desktop)this.getDesktop(), (String)("org.zkoss.zul.impl.NumberInputElement" + localeName))) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(this._locale);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("GROUPING", String.valueOf(symbols.getGroupingSeparator()));
                map.put("DECIMAL", String.valueOf(symbols.getDecimalSeparator()));
                map.put("PERCENT", String.valueOf(symbols.getPercent()));
                map.put("PER_MILL", String.valueOf(symbols.getPerMill()));
                map.put("MINUS", String.valueOf(symbols.getMinusSign()));
                return JSONValue.toJSONString((Object)new Object[]{localeName, map});
            }
            return JSONValue.toJSONString((Object)new Object[]{localeName, null});
        }
        return null;
    }

    protected Locale getDefaultLocale() {
        return this._locale != null ? this._locale : Locales.getCurrent();
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._rounding != 6) {
            renderer.render("_rounding", this._rounding);
        }
        if (this._locale != null) {
            renderer.render("localizedSymbols", this.getRealSymbols());
        }
    }

    protected String getDefaultFormat() {
        return Library.getProperty((String)"org.zkoss.zul.numberFormat", (String)"##,##0.##");
    }

    protected String formatNumber(Object value, String defaultFormat) {
        DecimalFormat df;
        block6: {
            String fmt;
            if (value == null) {
                return "";
            }
            df = (DecimalFormat)NumberFormat.getInstance(this.getDefaultLocale());
            if (this._rounding != 6) {
                df.setRoundingMode(RoundingMode.valueOf(this._rounding));
            }
            if ((fmt = this.getFormat()) == null) {
                fmt = defaultFormat;
            }
            if (fmt != null) {
                try {
                    df.applyPattern(fmt);
                }
                catch (IllegalArgumentException e) {
                    if (this._locale == null) break block6;
                    df.applyLocalizedPattern(fmt);
                }
            }
        }
        return df.format(value);
    }

    protected Object[] toNumberOnly(String val) {
        int j;
        if (val == null) {
            return new Object[]{null, null};
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.getDefaultLocale());
        char GROUPING = symbols.getGroupingSeparator();
        char DECIMAL = symbols.getDecimalSeparator();
        char PERCENT = symbols.getPercent();
        char PER_MILL = symbols.getPerMill();
        char MINUS = symbols.getMinusSign();
        String fmt = this.getFormat();
        StringBuffer sb = null;
        int divscale = 0;
        boolean minus = false;
        int len = val.length();
        for (j = 0; j < len; ++j) {
            char c2;
            char cc = val.charAt(j);
            boolean ignore = false;
            if (cc == PERCENT) {
                divscale += 2;
                ignore = true;
            } else if (cc == PER_MILL) {
                divscale += 3;
                ignore = true;
            } else if (cc == '(') {
                minus = true;
                ignore = true;
            } else if (cc == '+') {
                ignore = true;
            }
            if (!ignore) {
                boolean bl = ignore = (cc < '0' || cc > '9') && cc != DECIMAL && cc != MINUS && cc != '+' && (Character.isWhitespace(cc) || cc == GROUPING || cc == ')' || fmt != null && fmt.indexOf(cc) >= 0);
            }
            if (ignore) {
                if (sb != null) continue;
                sb = new StringBuffer(len).append(val.substring(0, j));
                continue;
            }
            char c = cc == MINUS ? (char)'-' : (c2 = cc == DECIMAL ? (char)'.' : (char)cc);
            if (cc != c2) {
                if (sb == null) {
                    sb = new StringBuffer(len).append(val.substring(0, j));
                }
                sb.append(c2);
                continue;
            }
            if (sb == null) continue;
            sb.append(c2);
        }
        if (minus) {
            if (sb == null) {
                sb = new StringBuffer(val.length() + 1).append(val);
            }
            if (sb.length() > 0) {
                if (sb.charAt(0) == '-') {
                    sb.deleteCharAt(0);
                } else {
                    sb.insert(0, '-');
                }
            }
        }
        if (fmt != null && divscale > 0) {
            int k;
            j = 0;
            int len2 = fmt.length();
            block1: while ((k = fmt.indexOf(39, j)) >= 0) {
                while (++k < len2) {
                    char cc = fmt.charAt(k);
                    if (cc == '%') {
                        divscale -= 2;
                    } else if (cc == '\u2030') {
                        divscale -= 3;
                    } else if (cc == '\'') break;
                    if (divscale > 0) continue;
                    divscale = 0;
                    break block1;
                }
                j = ++k;
            }
        }
        return new Object[]{sb != null ? sb.toString() : val, new Integer(divscale)};
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    static {
        _properties.put("locale", (PropertyAccess)new ObjectPropertyAccess(){

            public void setValue(Component cmp, Object locale) {
                if (locale instanceof String) {
                    ((NumberInputElement)cmp).setLocale((String)locale);
                } else if (locale instanceof Locale) {
                    ((NumberInputElement)cmp).setLocale((Locale)locale);
                }
            }

            public String getValue(Component cmp) {
                return ((NumberInputElement)cmp).getLocale().toString();
            }
        });
    }
}

