/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuSelect;
import org.zkoss.zk.au.out.AuWrongValue;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.ErrorEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.SelectionEvent;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.ext.Readonly;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.IntegerPropertyAccess;
import org.zkoss.zk.ui.sys.ObjectPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.StringPropertyAccess;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ClientConstraint;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.CustomConstraint;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.ext.Constrainted;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

public abstract class InputElement
extends XulElement
implements Constrainted,
Readonly,
Disable {
    private static final Logger log = LoggerFactory.getLogger(InputElement.class);
    protected Object _value;
    private int _cols;
    private AuxInfo _auxinf;
    private boolean _disabled;
    private boolean _readonly;
    private boolean _valided;
    private boolean _inplace;
    private String _placeholder;
    private static HashMap<String, PropertyAccess> _properties;

    public String getPlaceholder() {
        return this._placeholder;
    }

    public void setPlaceholder(String placeholder) {
        if (this._placeholder != placeholder) {
            this._placeholder = placeholder;
            this.smartUpdate("placeholder", this._placeholder);
        }
    }

    public void setInplace(boolean inplace) {
        if (this._inplace != inplace) {
            this._inplace = inplace;
            this.smartUpdate("inplace", this._inplace);
        }
    }

    public boolean isInplace() {
        return this._inplace;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.smartUpdate("readonly", this._readonly);
        }
    }

    public String getName() {
        return this._auxinf != null ? this._auxinf.name : null;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.name : null), (Object)name)) {
            this.initAuxInfo().name = name;
            this.smartUpdate("name", this.getName());
        }
    }

    public String getErrorMessage() {
        return this._auxinf != null ? this._auxinf.errmsg : null;
    }

    public void setErrorMessage(String errmsg) {
        if (errmsg != null && errmsg.length() > 0) {
            this.initAuxInfo().errmsg = errmsg;
            this.response((AuResponse)new AuWrongValue((Component)this, errmsg));
        } else {
            this.clearErrorMessage();
        }
    }

    public void clearErrorMessage(boolean revalidateRequired) {
        if (this._auxinf != null && this._auxinf.errmsg != null) {
            this._auxinf.errmsg = null;
            Clients.clearWrongValue((Component)this);
        }
        this._valided = !revalidateRequired;
    }

    public void clearErrorMessage() {
        this.clearErrorMessage(false);
    }

    public String getText() throws WrongValueException {
        this.checkUserError();
        return this.coerceToString(this._value);
    }

    public void setText(String value) throws WrongValueException {
        if (this._auxinf != null && this._auxinf.maxlength > 0 && value != null && value.length() > this._auxinf.maxlength) {
            throw new WrongValueException((Component)this, MZul.STRING_TOO_LONG, (Object)new Integer(this._auxinf.maxlength));
        }
        Object val = this.coerceFromString(value);
        boolean same = Objects.equals((Object)this._value, (Object)val);
        boolean errFound = false;
        if (!same || !this._valided || this._auxinf != null && this._auxinf.errmsg != null) {
            this.validate(val);
            errFound = this._auxinf != null && this._auxinf.errmsg != null;
            this.clearErrorMessage();
        }
        if (!same) {
            this._value = val;
            this.smartUpdate("_value", this.marshall(val));
        } else if (errFound) {
            this.smartUpdate("_value", this.marshall(this._value));
        }
    }

    protected abstract Object coerceFromString(String var1) throws WrongValueException;

    protected abstract String coerceToString(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(Object value) throws WrongValueException {
        Constraint constr = this.getConstraint();
        if (constr != null) {
            Scopes.beforeInterpret((Scope)this);
            try {
                constr.validate((Component)this, value);
                if (!this._auxinf.checkOnly && constr instanceof CustomConstraint) {
                    try {
                        ((CustomConstraint)((Object)constr)).showCustomError((Component)this, null);
                    }
                    catch (Throwable ex) {
                        log.error("", ex);
                    }
                }
            }
            finally {
                Scopes.afterInterpret();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WrongValueException showCustomError(WrongValueException ex) {
        if (this._auxinf != null && this._auxinf.constr instanceof CustomConstraint) {
            Scopes.beforeInterpret((Scope)this);
            try {
                ((CustomConstraint)((Object)this._auxinf.constr)).showCustomError((Component)this, ex);
            }
            catch (Throwable t) {
                log.error("", t);
            }
            finally {
                Scopes.afterInterpret();
            }
        }
        return ex;
    }

    public int getMaxlength() {
        return this._auxinf != null ? this._auxinf.maxlength : 0;
    }

    public void setMaxlength(int maxlength) {
        if ((this._auxinf != null ? this._auxinf.maxlength : 0) != maxlength) {
            this.initAuxInfo().maxlength = maxlength;
            this.smartUpdate("maxlength", this.getMaxlength());
        }
    }

    public int getCols() {
        return this._cols;
    }

    public void setCols(int cols) throws WrongValueException {
        if (cols <= 0) {
            throw new WrongValueException("Illegal cols: " + cols);
        }
        if (this._cols != cols) {
            this._cols = cols;
            this.smartUpdate("cols", this._cols);
        }
    }

    public int getTabindex() {
        return this._auxinf != null ? this._auxinf.tabindex : 0;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if ((this._auxinf != null ? this._auxinf.tabindex : 0) != tabindex) {
            this.initAuxInfo().tabindex = tabindex;
            this.smartUpdate("tabindex", this.getTabindex());
        }
    }

    public boolean getInstant() {
        return this.isInstant();
    }

    public boolean isInstant() {
        return this._auxinf != null && this._auxinf.instant;
    }

    public void setInstant(boolean instant) {
        if (this.getInstant() != instant) {
            this.initAuxInfo().instant = instant;
            this.smartUpdate("instant", this.getInstant());
        }
    }

    public boolean isMultiline() {
        return false;
    }

    public String getType() {
        return "text";
    }

    public void select() {
        this.response((AuResponse)new AuSelect((Component)this));
    }

    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? SimpleConstraint.getInstance(constr) : null);
    }

    public void setConstraint(Constraint constr) {
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.constr : null), (Object)constr)) {
            this.initAuxInfo().constr = constr;
            this._valided = false;
            if (this._auxinf.constr instanceof CustomConstraint) {
                this.smartUpdate("constraint", "[c");
                return;
            }
            if (this._auxinf.constr instanceof ClientConstraint) {
                Object code;
                ClientConstraint cc = (ClientConstraint)((Object)this._auxinf.constr);
                JavaScriptValue cpkgs = InputElement.getClientPackages(cc);
                if (cpkgs != null) {
                    this.smartUpdate("_0", cpkgs);
                }
                if ((code = InputElement.getClientConstraintCode(cc)) != null) {
                    if (code instanceof JavaScriptValue) {
                        this.smartUpdate("z$al", code);
                    } else {
                        this.smartUpdate("constraint", new JavaScriptValue((String)code));
                    }
                    return;
                }
            }
            this.smartUpdate("constraint", this._auxinf.constr != null ? "[s" : null);
        }
    }

    private static JavaScriptValue getClientPackages(ClientConstraint cc) {
        String cpkg = cc.getClientPackages();
        return cpkg != null ? new JavaScriptValue("zk.load('" + cpkg + "')") : null;
    }

    private static Object getClientConstraintCode(ClientConstraint cc) {
        String js = cc.getClientConstraint();
        if (js != null && js.length() > 0) {
            char c = js.charAt(0);
            if (c != '\'' && c != '\"') {
                return new JavaScriptValue("{constraint:function(){\nreturn " + js + ";}}");
            }
            return js;
        }
        return null;
    }

    public Constraint getConstraint() {
        return this._auxinf != null ? this._auxinf.constr : null;
    }

    protected Object getTargetValue() throws WrongValueException {
        this.checkUserError();
        return this._value;
    }

    public Object getRawValue() {
        return this._value;
    }

    public String getRawText() {
        return this.coerceToString(this._value);
    }

    public void setRawValue(Object value) {
        if (this._auxinf != null && this._auxinf.errmsg != null || !Objects.equals((Object)this._value, (Object)value)) {
            this.clearErrorMessage(true);
            this._value = value;
            this.smartUpdate("_value", this.marshall(this._value));
        }
    }

    protected void setValueDirectly(Object value) {
        this._value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this._auxinf != null && this._auxinf.errmsg != null) {
            return false;
        }
        if (!this._valided && this._auxinf != null && this._auxinf.constr != null) {
            this._auxinf.checkOnly = true;
            try {
                this.validate(this._value);
            }
            catch (Throwable ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                this._auxinf.checkOnly = false;
            }
        }
        return true;
    }

    public void setSelectedText(int start, int end, String newtxt, boolean isHighLight) {
        if (start <= end) {
            String txt = this.getText();
            int len = txt.length();
            if (start < 0) {
                start = 0;
            }
            if (start > len) {
                start = len;
            }
            if (end < 0) {
                end = 0;
            }
            if (end > len) {
                end = len;
            }
            if (newtxt == null) {
                newtxt = "";
            }
            this.setText(txt.substring(0, start) + newtxt + txt.substring(end));
            this.setSelectionRange(start, isHighLight ? start + newtxt.length() : start);
        }
    }

    public void setSelectionRange(int start, int end) {
        this.response((AuResponse)new AuSelect((Component)this, start, end));
    }

    protected void checkUserError() throws WrongValueException {
        if (this._auxinf != null && this._auxinf.errmsg != null) {
            throw new WrongValueException((Component)this, this._auxinf.errmsg);
        }
        if (!this._valided && this._auxinf != null && this._auxinf.constr != null) {
            this.setText(this.coerceToString(this._value));
        }
    }

    public String getErrorboxSclass() {
        return this._auxinf != null ? this._auxinf.errorboxSclass : null;
    }

    public void setErrorboxSclass(String sclass) {
        if (sclass != null && sclass.length() == 0) {
            sclass = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.errorboxSclass : null), (Object)sclass)) {
            this.initAuxInfo().errorboxSclass = sclass;
            this.smartUpdate("errorboxSclass", this.getErrorboxSclass());
        }
    }

    public String getErrorboxIconSclass() {
        return this._auxinf != null ? this._auxinf.errorboxIconSclass : null;
    }

    public void setErrorboxIconSclass(String iconSclass) {
        if (iconSclass != null && iconSclass.length() == 0) {
            iconSclass = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.errorboxSclass : null), (Object)iconSclass)) {
            this.initAuxInfo().errorboxIconSclass = iconSclass;
            this.smartUpdate("errorboxIconSclass", this.getErrorboxIconSclass());
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public WrongValueException onWrongValue(WrongValueException ex) {
        this.initAuxInfo().errmsg = Exceptions.getMessage((Throwable)ex);
        return this.showCustomError(ex);
    }

    protected Object marshall(Object value) {
        return value;
    }

    protected Object unmarshall(Object value) {
        return value;
    }

    private void setValueByClient(Object value, String valstr) {
        if (this._auxinf != null && this._auxinf.maxlength > 0 && valstr != null && valstr.length() > this._auxinf.maxlength) {
            throw new WrongValueException((Component)this, MZul.STRING_TOO_LONG, (Object)new Integer(this._auxinf.maxlength));
        }
        boolean same = Objects.equals((Object)this._value, (Object)value);
        boolean errFound = false;
        if (!same || !this._valided || this._auxinf != null && this._auxinf.errmsg != null) {
            this.validate(value);
            errFound = this._auxinf != null && this._auxinf.errmsg != null;
            this.clearErrorMessage();
        }
        if (!same) {
            this._value = value;
        } else if (errFound) {
            this.smartUpdate("_value", this.marshall(this._value));
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onChange")) {
            try {
                Object oldval = this._value;
                Object value = null;
                Map data = request.getData();
                String rawValue = (String)data.get("rawValue");
                if (rawValue != null) {
                    value = this.coerceFromString(rawValue);
                } else {
                    Object clientv = data.get("value");
                    try {
                        value = this.unmarshall(clientv);
                    }
                    catch (NumberFormatException ex) {
                        throw new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, clientv);
                    }
                }
                String valstr = this.coerceToString(value);
                this.setValueByClient(value, valstr);
                if (rawValue != null && !rawValue.equals(valstr)) {
                    this.smartUpdate("_value", this.marshall(this._value));
                }
                if (Objects.equals((Object)oldval, (Object)this._value)) {
                    return;
                }
                InputEvent evt = new InputEvent(cmd, (Component)this, valstr, oldval, AuRequests.getBoolean((Map)data, (String)"bySelectBack"), AuRequests.getInt((Map)data, (String)"start", (int)0));
                Events.postEvent((Event)evt);
            }
            catch (WrongValueException ex) {
                this.initAuxInfo().errmsg = ex.getMessage();
                throw ex;
            }
        }
        if (cmd.equals("onChanging")) {
            Map data = request.getData();
            Object clientv = data.get("value");
            Object oldval = this._value;
            InputEvent evt = new InputEvent(cmd, (Component)this, clientv == null ? "" : clientv.toString(), oldval, AuRequests.getBoolean((Map)data, (String)"bySelectBack"), AuRequests.getInt((Map)data, (String)"start", (int)0));
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onError")) {
            ErrorEvent evt = ErrorEvent.getErrorEvent((AuRequest)request, (Object)this._value);
            String msg = evt.getMessage();
            this.initAuxInfo().errmsg = msg != null && msg.length() > 0 ? msg : null;
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onSelection")) {
            Events.postEvent((Event)SelectionEvent.getSelectionEvent((AuRequest)request));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Constraint constr;
        int v;
        super.renderProperties(renderer);
        this.render(renderer, "_value", this.marshall(this._value));
        this.render(renderer, "readonly", this._readonly);
        this.render(renderer, "disabled", this._disabled);
        this.render(renderer, "name", this.getName());
        this.render(renderer, "inplace", this._inplace);
        if (this._placeholder != null) {
            this.render(renderer, "placeholder", this._placeholder);
        }
        if ((v = this.getMaxlength()) > 0) {
            renderer.render("maxlength", v);
        }
        if (this._cols > 0) {
            renderer.render("cols", this._cols);
        }
        if ((v = this.getTabindex()) != 0) {
            renderer.render("tabindex", v);
        }
        if (this.getInstant()) {
            renderer.render("instant", true);
        }
        boolean constrDone = false;
        Constraint constraint = constr = this._auxinf != null ? this._auxinf.constr : null;
        if (constr instanceof CustomConstraint) {
            renderer.render("constraint", "[c");
            constrDone = true;
        } else if (constr instanceof ClientConstraint) {
            ClientConstraint cc = (ClientConstraint)((Object)constr);
            this.render(renderer, "_0", InputElement.getClientPackages(cc));
            Object code = InputElement.getClientConstraintCode(cc);
            if (code != null) {
                if (code instanceof JavaScriptValue) {
                    renderer.render("z$al", code);
                } else {
                    renderer.renderDirectly("constraint", code);
                }
                constrDone = true;
            }
        }
        if (!constrDone && constr != null) {
            renderer.render("constraint", "[s");
        }
        Utils.renderCrawlableText(this.coerceToString(this._value));
        this.render(renderer, "errorboxSclass", this.getErrorboxSclass());
        this.render(renderer, "errorboxIconSclass", this.getErrorboxIconSclass());
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    public Object clone() {
        InputElement clone = (InputElement)super.clone();
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    private AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    static {
        InputElement.addClientEvent(InputElement.class, (String)"onChange", (int)16385);
        InputElement.addClientEvent(InputElement.class, (String)"onChanging", (int)8192);
        InputElement.addClientEvent(InputElement.class, (String)"onFocus", (int)8192);
        InputElement.addClientEvent(InputElement.class, (String)"onBlur", (int)8192);
        InputElement.addClientEvent(InputElement.class, (String)"onSelection", (int)16384);
        InputElement.addClientEvent(InputElement.class, (String)"onError", (int)8193);
        _properties = new HashMap(12);
        _properties.put("name", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String name) {
                ((InputElement)cmp).setName(name);
            }

            public String getValue(Component cmp) {
                return ((InputElement)cmp).getName();
            }
        });
        _properties.put("rawValue", (PropertyAccess)new ObjectPropertyAccess(){

            public void setValue(Component cmp, Object rawValue) {
                ((InputElement)cmp).setRawValue(rawValue);
            }

            public Object getValue(Component cmp) {
                return ((InputElement)cmp).getRawValue();
            }
        });
        _properties.put("disabled", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean disabled) {
                ((InputElement)cmp).setDisabled(disabled);
            }

            public Boolean getValue(Component cmp) {
                return ((InputElement)cmp).isDisabled();
            }
        });
        _properties.put("readonly", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean readonly) {
                ((InputElement)cmp).setReadonly(readonly);
            }

            public Boolean getValue(Component cmp) {
                return ((InputElement)cmp).isReadonly();
            }
        });
        _properties.put("placeholder", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String placeholder) {
                ((InputElement)cmp).setPlaceholder(placeholder);
            }

            public String getValue(Component cmp) {
                return ((InputElement)cmp).getPlaceholder();
            }
        });
        _properties.put("inplace", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean inplace) {
                ((InputElement)cmp).setInplace(inplace);
            }

            public Boolean getValue(Component cmp) {
                return ((InputElement)cmp).isInplace();
            }
        });
        _properties.put("instant", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean instant) {
                ((InputElement)cmp).setInstant(instant);
            }

            public Boolean getValue(Component cmp) {
                return ((InputElement)cmp).isInstant();
            }
        });
        _properties.put("maxlength", (PropertyAccess)new IntegerPropertyAccess(){

            public void setValue(Component cmp, Integer maxlength) {
                ((InputElement)cmp).setMaxlength(maxlength);
            }

            public Integer getValue(Component cmp) {
                return ((InputElement)cmp).getMaxlength();
            }
        });
        _properties.put("cols", (PropertyAccess)new IntegerPropertyAccess(){

            public void setValue(Component cmp, Integer cols) {
                ((InputElement)cmp).setCols(cols);
            }

            public Integer getValue(Component cmp) {
                return ((InputElement)cmp).getCols();
            }
        });
        _properties.put("tabindex", (PropertyAccess)new IntegerPropertyAccess(){

            public void setValue(Component cmp, Integer tabindex) {
                ((InputElement)cmp).setTabindex(tabindex);
            }

            public Integer getValue(Component cmp) {
                return ((InputElement)cmp).getTabindex();
            }
        });
        _properties.put("errorboxSclass", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String errorboxSclass) {
                ((InputElement)cmp).setErrorboxSclass(errorboxSclass);
            }

            public String getValue(Component cmp) {
                return ((InputElement)cmp).getErrorboxSclass();
            }
        });
        _properties.put("errorboxIconSclass", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String errorboxIconSclass) {
                ((InputElement)cmp).setErrorboxIconSclass(errorboxIconSclass);
            }

            public String getValue(Component cmp) {
                return ((InputElement)cmp).getErrorboxIconSclass();
            }
        });
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private String errmsg;
        private String name;
        private int maxlength;
        private int tabindex;
        private boolean instant;
        private Constraint constr;
        private transient boolean checkOnly;
        private String errorboxSclass;
        private String errorboxIconSclass;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

