/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Generics;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.CloneableEventListener;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Foot;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.Group;
import org.zkoss.zul.Groupfoot;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelMap;
import org.zkoss.zul.Paging;
import org.zkoss.zul.PagingEventPublisher;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.RowRendererExt;
import org.zkoss.zul.Rows;
import org.zkoss.zul.event.DataLoadingEvent;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PageSizeEvent;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.event.RenderEvent;
import org.zkoss.zul.ext.Pageable;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Sortable;
import org.zkoss.zul.impl.DataLoader;
import org.zkoss.zul.impl.GridDataLoader;
import org.zkoss.zul.impl.GroupsListModel;
import org.zkoss.zul.impl.MeshElement;
import org.zkoss.zul.impl.Padding;
import org.zkoss.zul.impl.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid
extends MeshElement {
    private static final Logger log = LoggerFactory.getLogger(Grid.class);
    private static final long serialVersionUID = 20091111L;
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.Grid.onInitLaterPosted";
    private static final String ATTR_ON_PAGING_INIT_RENDERER_POSTED = "org.zkoss.zul.Grid.onPagingInitLaterPosted";
    private static final int INIT_LIMIT = 50;
    private transient DataLoader _dataLoader;
    private transient Rows _rows;
    private transient Columns _cols;
    private transient Foot _foot;
    private transient Frozen _frozen;
    private transient Collection<Component> _heads;
    private transient ListModel<?> _model;
    private transient RowRenderer<?> _renderer;
    private transient ListDataListener _dataListener;
    private transient Paginal _pgi;
    private transient Paging _paging;
    private EventListener<Event> _pgListener;
    private EventListener<Event> _pgImpListener;
    private EventListener<Event> _modelInitListener;
    private String _scOddRow = null;
    private int _preloadsz = 50;
    private String _innerWidth = "100%";
    private int _currentTop = 0;
    private int _currentLeft = 0;
    private int _topPad;
    private boolean _renderAll;
    private transient boolean _rod;
    private String _emptyMessage;

    public Grid() {
        this.init();
    }

    private void init() {
        this._heads = new AbstractCollection<Component>(){

            @Override
            public int size() {
                int sz = Grid.this.getChildren().size();
                if (Grid.this._rows != null) {
                    --sz;
                }
                if (Grid.this._foot != null) {
                    --sz;
                }
                if (Grid.this._paging != null) {
                    --sz;
                }
                if (Grid.this._frozen != null) {
                    --sz;
                }
                return sz;
            }

            @Override
            public Iterator<Component> iterator() {
                return new Iter();
            }
        };
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (oldpage == null) {
            Executions.getCurrent().setAttribute("zkoss.Grid.deferInitModel_" + this.getUuid(), (Object)Boolean.TRUE);
            this._modelInitListener = new ModelInitListener();
            this.addEventListener("onInitModel", (EventListener)this._modelInitListener);
            Events.postEvent((int)20000, (Event)new Event("onInitModel", (Component)this));
        }
        if (this._model != null && this._dataListener != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model.addListDataListener(this._dataListener);
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this._model != null && this._dataListener != null) {
            this._model.removeListDataListener(this._dataListener);
        }
    }

    private void resetDataLoader() {
        this.resetDataLoader(true);
    }

    private void resetDataLoader(boolean shallReset) {
        if (this._dataLoader != null) {
            if (shallReset) {
                this._dataLoader.reset();
                this.smartUpdate("_lastoffset", 0);
            }
            this._dataLoader = null;
        }
        if (shallReset) {
            this.smartUpdate("resetDataLoader", true);
            this._currentTop = 0;
            this._currentLeft = 0;
            this._topPad = 0;
        }
    }

    public boolean isVflex() {
        String vflex = this.getVflex();
        if ("true".equals(vflex) || "min".equals(vflex)) {
            return true;
        }
        if (Strings.isBlank((String)vflex) || "false".equals(vflex)) {
            return false;
        }
        return Integer.parseInt(vflex) > 0;
    }

    public void setVflex(boolean vflex) {
        if (this.isVflex() != vflex) {
            this.setVflex(String.valueOf(vflex));
        }
    }

    public void setFixedLayout(boolean fixedLayout) {
        this.setSizedByContent(!fixedLayout);
    }

    public boolean isFixedLayout() {
        return !this.isSizedByContent();
    }

    public Rows getRows() {
        return this._rows;
    }

    public Columns getColumns() {
        return this._cols;
    }

    public Foot getFoot() {
        return this._foot;
    }

    public Frozen getFrozen() {
        return this._frozen;
    }

    public Collection<Component> getHeads() {
        return this._heads;
    }

    public Component getCell(int row, int col) {
        Rows rows = this.getRows();
        if (rows == null) {
            return null;
        }
        List children = rows.getChildren();
        if (children.size() <= row) {
            return null;
        }
        return (children = ((Row)((Object)children.get(row))).getChildren()).size() <= col ? null : (Component)children.get(col);
    }

    public String getAlign() {
        return null;
    }

    public void setAlign(String align) {
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this._rows != null ? this.getDataLoader().getTotalSize() : 0);
                    this.addPagingListener(this._pgi);
                    if (this._pgi instanceof Component) {
                        this.smartUpdate("paginal", this._pgi);
                    }
                }
                if (this._model instanceof Pageable) {
                    Pageable m = (Pageable)((Object)this._model);
                    m.setActivePage(this._pgi.getActivePage());
                    m.setPageSize(this._pgi.getPageSize());
                }
            }
        }
    }

    private void newInternalPaging() {
        MeshElement.InternalPaging paging = new MeshElement.InternalPaging(this);
        paging.setDetailed(true);
        paging.applyProperties();
        if (this._model instanceof Pageable && ((Pageable)((Object)this._model)).getPageSize() != -1) {
            paging.setPageSize(((Pageable)((Object)this._model)).getPageSize());
        }
        paging.setTotalSize(this._rows != null ? this.getDataLoader().getTotalSize() : 0);
        if (this._model instanceof Pageable && ((Pageable)((Object)this._model)).getActivePage() != -1) {
            paging.setActivePage(((Pageable)((Object)this._model)).getActivePage());
        }
        paging.setParent((Component)this);
        if (this._pgi != null) {
            this.addPagingListener(this._pgi);
        }
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new PGListener();
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._model instanceof PagingEventPublisher) {
            ((PagingEventPublisher)((Object)this._model)).addPagingEventListener((PagingListener)this._pgListener);
        }
        if (this._pgImpListener == null) {
            this._pgImpListener = new PGImpListener();
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        if (this._model instanceof PagingEventPublisher) {
            ((PagingEventPublisher)((Object)this._model)).removePagingEventListener((PagingListener)this._pgListener);
        }
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public Paging getPagingChild() {
        return this._paging;
    }

    @Override
    protected Paginal pgi() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi;
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    public <T> ListModel<T> getModel() {
        return this._model;
    }

    public <T> ListModel<T> getListModel() {
        return this._model instanceof GroupsListModel ? null : this._model;
    }

    public <D, G, F> GroupsModel<D, G, F> getGroupsModel() {
        return this._model instanceof GroupsListModel ? ((GroupsListModel)this._model).getGroupsModel() : null;
    }

    public void setModel(ListModel<?> model) {
        if (model != null) {
            Execution exec;
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                    this.resetDataLoader();
                }
                if (this._rows != null) {
                    this._rows.getChildren().clear();
                }
                this.smartUpdate("model", model instanceof GroupsListModel || model instanceof GroupsModel ? "group" : Boolean.valueOf(true));
                this._model = model;
                this.initDataListener();
                this.setAttribute("org.zkoss.zul.BeforeModelItemsRendered", Boolean.TRUE);
            }
            if (this.inPagingMold()) {
                Pageable m;
                Paginal pgi = this.getPaginal();
                Pageable pageable = m = this._model instanceof Pageable ? (Pageable)((Object)this._model) : null;
                if (m != null) {
                    if (m.getPageSize() != -1) {
                        pgi.setPageSize(m.getPageSize());
                    } else {
                        m.setPageSize(pgi.getPageSize());
                    }
                }
                pgi.setTotalSize(this.getDataLoader().getTotalSize());
                if (m != null) {
                    if (m.getActivePage() != -1) {
                        pgi.setActivePage(m.getActivePage());
                    } else {
                        m.setActivePage(pgi.getActivePage());
                    }
                }
            }
            boolean defer = (exec = Executions.getCurrent()) == null ? false : exec.getAttribute("zkoss.Grid.deferInitModel_" + this.getUuid()) != null;
            boolean rod = this.evalRod();
            if (!defer || !rod) {
                this.getDataLoader().syncModel(-1, -1);
                this.removeAttribute("org.zkoss.zul.BeforeModelItemsRendered");
            }
            if (!Grid.doSort(this)) {
                this.postOnInitRender();
            }
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            if (this._rows != null) {
                this._rows.getChildren().clear();
            }
            this.smartUpdate("model", false);
        }
        this.getDataLoader().updateModelInfo();
    }

    public void setModel(GroupsModel<?, ?, ?> model) {
        this.setModel(model != null ? GroupsListModel.toListModel(model) : null);
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    if (event.getType() != 4) {
                        Grid.this.onListDataChange(event);
                    }
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    private static boolean doSort(Grid grid) {
        Columns cols = grid.getColumns();
        if (!grid.isAutosort() || cols == null) {
            return false;
        }
        for (Column hd : cols.getChildren()) {
            String dir = hd.getSortDirection();
            if ("natural".equals(dir)) continue;
            hd.doSort("ascending".equals(dir));
            return true;
        }
        return false;
    }

    public <T> RowRenderer<T> getRowRenderer() {
        return this._renderer;
    }

    public void setRowRenderer(RowRenderer<?> renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            if (this._model != null) {
                if (renderer instanceof RowRendererExt || this._renderer instanceof RowRendererExt) {
                    this.getRows().getChildren().clear();
                    this.getDataLoader().syncModel(-1, -1);
                } else if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
                    this.getDataLoader().syncModel(-1, -1);
                } else {
                    Execution exec = Executions.getCurrent();
                    boolean defer = exec == null ? false : exec.getAttribute("zkoss.Grid.deferInitModel_" + this.getUuid()) != null;
                    boolean rod = this.evalRod();
                    if (!defer || !rod) {
                        this.getDataLoader().syncModel(-1, -1);
                    }
                }
            }
        }
    }

    public void setRowRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setRowRenderer((RowRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public int getPreloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        return size != null ? Integer.parseInt(size) : this._preloadsz;
    }

    public void setPreloadSize(int sz) {
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        this._preloadsz = sz;
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        this.doInitRenderer();
    }

    public void onPagingInitRender() {
        this.removeAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED);
        this.doInitRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitRenderer() {
        Renderer renderer = new Renderer();
        try {
            Row row;
            int ofs;
            int pgsz;
            if (this.inPagingMold()) {
                pgsz = this._pgi.getPageSize();
                ofs = this._pgi.getActivePage() * pgsz;
            } else {
                pgsz = this.getDataLoader().getLimit();
                ofs = this.getDataLoader().getOffset();
            }
            int cnt = this._rows.getChildren().size() + this.getDataLoader().getOffset();
            if (ofs >= cnt && (ofs = cnt - pgsz) < 0) {
                ofs = 0;
            }
            int j = 0;
            int index = 0;
            int realOfs = ofs - this.getDataLoader().getOffset();
            if (realOfs < 0) {
                realOfs = 0;
            }
            boolean open = true;
            Row row2 = row = this._rows.getChildren().size() <= realOfs ? null : (Row)((Object)this._rows.getChildren().get(realOfs));
            while (j < pgsz && row != null) {
                Row nxt = (Row)row.getNextSibling();
                if (row.isVisible() && (open || row instanceof Groupfoot || row instanceof Group)) {
                    renderer.render(row, index + ofs);
                    ++j;
                }
                if (row instanceof Group) {
                    open = ((Group)row).isOpen();
                }
                ++index;
                row = nxt;
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
        this.removeAttribute("org.zkoss.zul.BeforeModelItemsRendered");
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    private void postOnPagingInitRender() {
        if (this.getAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED) == null && this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onPagingInitRender", (Component)this, null);
        }
    }

    private void onListDataChange(ListDataEvent event) {
        int type = event.getType();
        if (!(type != 1 && type != 0 || this.isIgnoreSortWhenChanged())) {
            Grid.doSort(this);
        } else {
            if (this.getAttribute("org.zkoss.zul.BeforeModelItemsRendered") != null && (type == 1 || type == 2)) {
                return;
            }
            this.getDataLoader().doListDataChange(event);
            this.postOnInitRender();
            if (type == 3 && this._model instanceof Sortable && this._cols != null) {
                Sortable smodel = (Sortable)Generics.cast(this._model);
                List cols = Generics.cast((List)this._cols.getChildren());
                boolean found = false;
                for (Column col : cols) {
                    if (found) {
                        col.setSortDirection("natural");
                        continue;
                    }
                    Comparator cmpr = (Comparator)Generics.cast(col.getSortAscending());
                    String dir = smodel.getSortDirection(cmpr);
                    boolean bl = found = !"natural".equals(dir);
                    if (!found) {
                        cmpr = (Comparator)Generics.cast(col.getSortDescending());
                        dir = smodel.getSortDirection(cmpr);
                        found = !"natural".equals(dir);
                    }
                    col.setSortDirection(dir);
                }
            }
        }
    }

    private static Label newRenderLabel(String value) {
        Label label = new Label(value != null && value.length() > 0 ? value : " ");
        label.setPre(true);
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderRow(Row row) {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            renderer.render(row, row.getIndex());
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAll() {
        if (this._model == null) {
            return;
        }
        this._renderAll = true;
        this.getDataLoader().setLoadAll(this._renderAll);
        Renderer renderer = new Renderer();
        if (!this._rows.getChildren().isEmpty()) {
            try {
                Row row = (Row)((Object)this._rows.getChildren().get(0));
                int index = row.getIndex();
                while (row != null) {
                    Row nxt = (Row)row.getNextSibling();
                    renderer.render(row, index++);
                    row = nxt;
                }
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    public void renderRows(Set<? extends Row> rows) {
        this.renderItems(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set<? extends Row> rows) {
        if (this._model == null) {
            if (log.isDebugEnabled()) {
                log.debug("No model no render");
            }
            return;
        }
        if (rows.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            for (Row row : rows) {
                renderer.render(row, row.getIndex());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public String getOddRowSclass() {
        return this._scOddRow == null ? this.getZclass() + "-odd" : this._scOddRow;
    }

    public void setOddRowSclass(String scls) {
        if (scls != null && scls.length() == 0) {
            scls = null;
        }
        if (!Objects.equals((Object)this._scOddRow, (Object)scls)) {
            this._scOddRow = scls;
            this.smartUpdate("oddRowSclass", scls);
        }
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
                if (this.getModel() != null) {
                    this.getDataLoader().syncModel(0, this.initRodSize());
                    this.postOnInitRender();
                }
                this.invalidate();
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
                this._topPad = 0;
                this._currentTop = 0;
                this._currentLeft = 0;
                Events.postEvent((int)10001, (Event)new PagingEvent("onPagingImpl", (Component)this._pgi, this._pgi.getActivePage()));
                this.invalidate();
            }
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-grid" : this._zclass;
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof Rows) {
            if (this._rows != null && this._rows != newChild) {
                throw new UiException("Only one rows child is allowed: " + this + "\nNote: rows is created automatically if live data");
            }
        } else if (newChild instanceof Columns) {
            if (this._cols != null && this._cols != newChild) {
                throw new UiException("Only one columns child is allowed: " + this);
            }
        } else if (newChild instanceof Frozen) {
            if (this._frozen != null && this._frozen != newChild) {
                throw new UiException("Only one frozen child is allowed: " + this);
            }
        } else if (newChild instanceof Paging) {
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + this);
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
        } else if (newChild instanceof Foot) {
            if (this._foot != null && this._foot != newChild) {
                throw new UiException("Only one foot child is allowed: " + this);
            }
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported child for grid: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Rows) {
            if (super.insertBefore(newChild, refChild)) {
                this._rows = (Rows)newChild;
                return true;
            }
        } else if (newChild instanceof Columns) {
            if (super.insertBefore(newChild, refChild)) {
                this._cols = (Columns)newChild;
                return true;
            }
        } else if (newChild instanceof Frozen) {
            if (super.insertBefore(newChild, refChild)) {
                this._frozen = (Frozen)newChild;
                return true;
            }
        } else if (newChild instanceof Paging) {
            if (super.insertBefore(newChild, refChild)) {
                this._paging = (Paging)newChild;
                this._pgi = this._paging;
                return true;
            }
        } else if (newChild instanceof Foot) {
            if (super.insertBefore(newChild, refChild)) {
                this._foot = (Foot)newChild;
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    public boolean removeChild(Component child) {
        if (this._paging == child && this._pgi == child && this.inPagingMold()) {
            throw new IllegalStateException("The paging component cannot be removed manually. It is removed automatically when changing the mold");
        }
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._rows == child) {
            this._rows = null;
        } else if (this._cols == child) {
            this._cols = null;
        } else if (this._frozen == child) {
            this._frozen = null;
        } else if (this._foot == child) {
            this._foot = null;
        } else if (this._paging == child) {
            this._paging = null;
            if (this._pgi == child) {
                this._pgi = null;
            }
        }
        return true;
    }

    @Override
    protected boolean isAutohidePaging() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.grid.autohidePaging", true, true);
    }

    boolean evalRod() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.grid.rod", false, true) && !(this._model instanceof GroupsListModel);
    }

    boolean isAutosort() {
        String attr = "org.zkoss.zul.grid.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val instanceof Boolean ? (Boolean)val : (val != null ? "true".equals(val) || "ignore.change".equals(val) : false);
    }

    private int preloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        int sz = size != null ? Integer.parseInt(size) : this._preloadsz;
        if ((sz = Utils.getIntAttribute((Component)this, "org.zkoss.zul.grid.preloadSize", sz, true)) < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        return sz;
    }

    private int initRodSize() {
        int sz = Utils.getIntAttribute((Component)this, "org.zkoss.zul.grid.initRodSize", 50, true);
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        return sz;
    }

    private boolean isIgnoreSortWhenChanged() {
        String attr = "org.zkoss.zul.grid.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val == null ? true : "ignore.change".equals(val);
    }

    DataLoader getDataLoader() {
        if (this._dataLoader == null) {
            this._rod = this.evalRod();
            String loadercls = Library.getProperty((String)"org.zkoss.zul.grid.DataLoader.class");
            try {
                this._dataLoader = this._rod && loadercls != null ? (DataLoader)Classes.forNameByThread((String)loadercls).newInstance() : new GridDataLoader();
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            this._dataLoader.init((Component)this, 0, this.initRodSize());
        }
        return this._dataLoader;
    }

    @Override
    public Object clone() {
        Grid clone = (Grid)super.clone();
        clone.init();
        clone._pgListener = null;
        clone._pgImpListener = null;
        int offset = clone.getDataLoader().getOffset();
        int cnt = 0;
        if (clone._rows != null) {
            ++cnt;
        }
        if (clone._cols != null) {
            ++cnt;
        }
        if (clone._foot != null) {
            ++cnt;
        }
        if (clone._frozen != null) {
            ++cnt;
        }
        if (clone._paging != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        int limit = clone.getDataLoader().getLimit();
        clone.resetDataLoader(false);
        clone.getDataLoader().init((Component)clone, offset, limit);
        if (clone._model != null) {
            ListModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (ListModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone._dataListener = null;
            clone.initDataListener();
            clone.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
            clone.removeAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED);
            clone.getDataLoader().setLoadAll(this._renderAll);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        for (Object child : this.getChildren()) {
            if (child instanceof Rows) {
                this._rows = (Rows)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Columns) {
                this._cols = (Columns)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Paging) {
                this._paging = (Paging)child;
                this._pgi = this._paging;
                this.addPagingListener(this._pgi);
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Frozen) {
                this._frozen = (Frozen)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Foot)) continue;
            this._foot = (Foot)((Object)child);
            if (--cnt != 0) continue;
            break;
        }
    }

    public String getEmptyMessage() {
        return this._emptyMessage;
    }

    public void setEmptyMessage(String emptyMessage) {
        if (!Objects.equals((Object)emptyMessage, (Object)this._emptyMessage)) {
            this._emptyMessage = emptyMessage;
            this.smartUpdate("emptyMessage", this._emptyMessage);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, this._model);
        this.willSerialize(this._renderer);
        Serializables.smartWrite((ObjectOutputStream)s, this._renderer);
        if (this._dataLoader != null) {
            s.writeInt(this._dataLoader.getOffset());
            s.writeInt(this._dataLoader.getLimit());
        } else {
            s.writeInt(0);
            s.writeInt(100);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (ListModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (RowRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this.init();
        this.afterUnmarshal(-1);
        int offset = s.readInt();
        int limit = s.readInt();
        this.resetDataLoader(false);
        this.getDataLoader().init((Component)this, offset, limit);
        if (this._model != null) {
            this.initDataListener();
            this.getDataLoader().setLoadAll(this._renderAll);
            if (this._model instanceof ListModelMap && this._rows != null) {
                for (Component o : this._rows.getChildren()) {
                    Row item = (Row)o;
                    item.setValue(this._model.getElementAt(item.getIndex()));
                }
            }
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "oddRowSclass", this._scOddRow);
        if (this._model != null) {
            this.render(renderer, "model", this._model instanceof GroupsListModel || this._model instanceof GroupsModel ? "group" : Boolean.valueOf(true));
        }
        if (!"100%".equals(this._innerWidth)) {
            this.render(renderer, "innerWidth", this._innerWidth);
        }
        if (this._currentTop != 0) {
            renderer.render("_currentTop", this._currentTop);
        }
        if (this._currentLeft != 0) {
            renderer.render("_currentLeft", this._currentLeft);
        }
        renderer.render("_topPad", this._topPad);
        renderer.render("emptyMessage", this._emptyMessage);
        renderer.render("_totalSize", this.getDataLoader().getTotalSize());
        renderer.render("_offset", this.getDataLoader().getOffset());
        if (this._rod) {
            int sz;
            if (((Cropper)this.getDataLoader()).isCropper()) {
                renderer.render("_grid$rod", true);
            }
            if ((sz = this.initRodSize()) != 50) {
                renderer.render("initRodSize", this.initRodSize());
            }
        }
        if (this._pgi != null && this._pgi instanceof Component) {
            renderer.render("paginal", (Object)this._pgi);
        }
    }

    boolean isRod() {
        return this._rod;
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onDataLoading")) {
            Events.postEvent((Event)DataLoadingEvent.getDataLoadingEvent(request, this.preloadSize()));
        } else if (this.inPagingMold() && cmd.equals("onPageSize")) {
            int oldsize;
            Map data = request.getData();
            int size = AuRequests.getInt((Map)data, (String)"size", (int)(oldsize = this.getPageSize()));
            if (size != oldsize) {
                int begin = this.getActivePage() * oldsize;
                int end = begin + oldsize;
                end = Math.min(this.getPaginal().getTotalSize(), end);
                int sel = size > oldsize ? end - 1 : begin;
                int newpg = sel / size;
                this.setPageSize(size);
                this.setActivePage(newpg);
                Events.postEvent((Event)new PageSizeEvent(cmd, (Component)this, this.pgi(), size));
            }
        } else if (cmd.equals("onScrollPos")) {
            Map data = request.getData();
            this._currentTop = AuRequests.getInt((Map)data, (String)"top", (int)0);
            this._currentLeft = AuRequests.getInt((Map)data, (String)"left", (int)0);
        } else if (cmd.equals("onTopPad")) {
            this._topPad = AuRequests.getInt((Map)request.getData(), (String)"topPad", (int)0);
        } else if (cmd.equals("onInnerWidth")) {
            String width = AuRequests.getInnerWidth((AuRequest)request);
            this._innerWidth = width == null ? "100%" : width;
        } else if (cmd.equals("onRender")) {
            RenderEvent event = RenderEvent.getRenderEvent(request);
            Set items = event.getItems();
            int cnt = items.size();
            if (cnt == 0) {
                return;
            }
            if ((cnt = 20 - cnt) > 0 && this._preloadsz > 0) {
                Row row;
                if (cnt > this._preloadsz) {
                    cnt = this._preloadsz;
                }
                LinkedList<Row> toload = new LinkedList<Row>();
                Iterator it = this.getRows().getChildren().iterator();
                while (it.hasNext() && !items.contains((Object)(row = (Row)((Object)it.next())))) {
                    if (row.isLoaded()) continue;
                    toload.add(0, row);
                }
                if (!toload.isEmpty()) {
                    int bfcnt = cnt / 3;
                    Iterator e = toload.iterator();
                    while (bfcnt > 0 && e.hasNext()) {
                        items.add(e.next());
                        --bfcnt;
                        --cnt;
                    }
                }
                while (cnt > 0 && it.hasNext()) {
                    row = (Row)((Object)it.next());
                    if (row.isLoaded() || !items.add(row)) continue;
                    --cnt;
                }
            }
            this.renderItems(items);
        } else {
            super.service(request, everError);
        }
    }

    @Override
    public void setActivePage(int pg) throws WrongValueException {
        if (this._model instanceof Pageable) {
            ((Pageable)((Object)this._model)).setActivePage(pg);
        }
        super.setActivePage(pg);
    }

    @Override
    public void setPageSize(int pgsz) throws WrongValueException {
        if (this._model instanceof Pageable) {
            ((Pageable)((Object)this._model)).setPageSize(pgsz);
        }
        super.setPageSize(pgsz);
    }

    static {
        Grid.addClientEvent(Grid.class, (String)"onRender", (int)8195);
        Grid.addClientEvent(Grid.class, (String)"onInnerWidth", (int)8193);
        Grid.addClientEvent(Grid.class, (String)"onScrollPos", (int)8193);
        Grid.addClientEvent(Grid.class, (String)"onTopPad", (int)8192);
        Grid.addClientEvent(Grid.class, (String)"onDataLoading", (int)8195);
        Grid.addClientEvent(Grid.class, (String)"onPageSize", (int)8195);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Iter
    implements Iterator<Component> {
        private final ListIterator<Component> _it;

        private Iter() {
            this._it = Grid.this.getChildren().listIterator();
        }

        @Override
        public boolean hasNext() {
            while (this._it.hasNext()) {
                Component o = this._it.next();
                if (!(o instanceof Columns) && !(o instanceof Auxhead)) continue;
                this._it.previous();
                return true;
            }
            return false;
        }

        @Override
        public Component next() {
            Component o;
            while (!((o = this._it.next()) instanceof Columns) && !(o instanceof Auxhead)) {
            }
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Padding {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Grid.this);
        }

        public int getHeight() {
            return Grid.this._topPad;
        }

        public void setHeight(int height) {
            Grid.this._topPad = height;
        }
    }

    class Renderer {
        private final RowRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        Renderer() {
            this._renderer = (RowRenderer)Grid.this.getDataLoader().getRealRenderer();
        }

        void render(Row row, int index) throws Throwable {
            if (row.isLoaded()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            Component cell = row.getFirstChild();
            if (!(this._renderer instanceof RowRendererExt) || (((RowRendererExt)((Object)this._renderer)).getControls() & 1) != 0) {
                cell.detach();
            }
            boolean oldFlag = Grid.this._rows.setReplacingRow(true);
            try {
                Object value = Grid.this._model.getElementAt(index);
                try {
                    this._renderer.render(row, value, index);
                }
                catch (AbstractMethodError ex) {
                    Method m = this._renderer.getClass().getMethod("render", Row.class, Object.class);
                    m.setAccessible(true);
                    m.invoke((Object)this._renderer, new Object[]{row, value});
                }
                Object v = row.getAttribute("org.zkoss.zul.model.renderAs");
                if (v != null) {
                    row = (Row)((Object)v);
                }
            }
            catch (Throwable ex) {
                try {
                    Label label = Grid.newRenderLabel(Exceptions.getMessage((Throwable)ex));
                    label.applyProperties();
                    label.setParent((Component)row);
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                row.setLoaded(true);
                throw ex;
            }
            finally {
                Grid.this._rows.setReplacingRow(oldFlag);
                if (row.getChildren().isEmpty()) {
                    cell.setParent((Component)row);
                }
            }
            row.setLoaded(true);
            this._rendered = true;
        }

        void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }

    private class PGImpListener
    implements PagingListener {
        private PGImpListener() {
        }

        public void onEvent(Event event) {
            if (Grid.this._rows != null && Grid.this._model != null && Grid.this.inPagingMold()) {
                Paginal pgi = Grid.this.getPaginal();
                int pgsz = pgi.getPageSize();
                int ofs = pgi.getActivePage() * pgsz;
                if (event instanceof PagingEvent) {
                    pgsz = ((PagingEvent)event).getPageable().getPageSize();
                    ofs = ((PagingEvent)event).getActivePage() * pgsz;
                }
                if (Grid.this._rod) {
                    Grid.this.getDataLoader().syncModel(ofs, pgsz);
                }
                Grid.this.postOnPagingInitRender();
            }
            if (Grid.this.getModel() != null || Grid.this.getPagingPosition().equals("both")) {
                Grid.this.invalidate();
            } else if (Grid.this._rows != null) {
                Grid.this._rows.invalidate();
                if (Grid.this._frozen != null) {
                    Grid.this._frozen.invalidate();
                }
            }
        }

        public Object willClone(Component comp) {
            return null;
        }
    }

    private class PGListener
    implements PagingListener {
        private PGListener() {
        }

        public void onEvent(Event event) {
            if (event instanceof PagingEvent) {
                PagingEvent pe = (PagingEvent)event;
                int pgsz = pe.getPageable().getPageSize();
                int actpg = pe.getActivePage();
                if ("internalModelEvent".equals(pe.getName())) {
                    if (pgsz != -1) {
                        Grid.this._pgi.setPageSize(pgsz);
                    }
                    if (actpg != -1) {
                        Grid.this._pgi.setActivePage(actpg);
                    }
                } else if (Grid.this._model instanceof Pageable) {
                    ((Pageable)((Object)Grid.this._model)).setActivePage(actpg);
                }
                Events.postEvent((Event)new PagingEvent(event.getName(), (Component)Grid.this, pe.getPageable(), actpg));
            }
        }

        public Object willClone(Component comp) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelInitListener
    implements SerializableEventListener<Event>,
    CloneableEventListener<Event> {
        private ModelInitListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (Grid.this._modelInitListener != null) {
                Grid.this.removeEventListener("onInitModel", Grid.this._modelInitListener);
                Grid.this._modelInitListener = null;
            }
            if (Grid.this._dataLoader != null) {
                boolean rod = Grid.this.evalRod();
                if (Grid.this._rod != rod || Grid.this.getRows() == null || Grid.this.getRows().getChildren().isEmpty()) {
                    if (Grid.this._model != null) {
                        if (Grid.this.getRows() != null) {
                            Grid.this.getRows().getChildren().clear();
                        }
                        Grid.this.resetDataLoader();
                        this.initModel();
                    } else {
                        Grid.this.resetDataLoader();
                        Executions.getCurrent().removeAttribute("zkoss.Grid.deferInitModel_" + Grid.this.getUuid());
                    }
                }
            } else if (Grid.this._model != null) {
                this.initModel();
            } else {
                Executions.getCurrent().removeAttribute("zkoss.Grid.deferInitModel_" + Grid.this.getUuid());
            }
            DataLoader loader = Grid.this.getDataLoader();
            Paginal pgi = Grid.this.getPaginal();
            if (pgi != null) {
                pgi.setTotalSize(loader.getTotalSize());
            }
        }

        private void initModel() {
            Executions.getCurrent().removeAttribute("zkoss.Grid.deferInitModel_" + Grid.this.getUuid());
            Grid.this.setModel(Grid.this._model);
        }

        public Object willClone(Component comp) {
            return null;
        }
    }
}

