/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.ScrollEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Slider
extends XulElement {
    private String _orient = "horizontal";
    private int _curpos;
    private int _maxpos = 100;
    private int _pginc = -1;
    private String _name;
    private String _slidingtext = "{0}";

    public Slider() {
        this.setWidth("207px");
    }

    public Slider(int curpos) {
        this();
        this.setCurpos(curpos);
    }

    boolean inScaleMold() {
        return "scale".equals(this.getMold());
    }

    boolean inSphereMold() {
        return "sphere".equals(this.getMold());
    }

    public String getZclass() {
        String name = "z-slider";
        if (this._zclass == null) {
            if (this.inScaleMold()) {
                return "z-slider-scale";
            }
            if (this.inSphereMold()) {
                return "z-slider" + ("horizontal".equals(this.getOrient()) ? "-sphere-hor" : "-sphere-ver");
            }
            return "z-slider" + ("horizontal".equals(this.getOrient()) ? "-hor" : "-ver");
        }
        return this._zclass;
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!this._orient.equals(orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public String getSlidingtext() {
        return this._slidingtext;
    }

    public void setSlidingtext(String slidingtext) {
        if (slidingtext == null || slidingtext.length() == 0) {
            slidingtext = "{0}";
        }
        if (!this._slidingtext.equals(slidingtext)) {
            this._slidingtext = slidingtext;
            this.smartUpdate("slidingtext", this._slidingtext);
        }
    }

    public int getCurpos() {
        return this._curpos;
    }

    public void setCurpos(int curpos) throws WrongValueException {
        if (curpos < 0) {
            curpos = 0;
        } else if (curpos > this._maxpos) {
            curpos = this._maxpos;
        }
        if (this._curpos != curpos) {
            this._curpos = curpos;
            this.smartUpdate("curpos", this._curpos);
        }
    }

    public int getMaxpos() {
        return this._maxpos;
    }

    public void setMaxpos(int maxpos) throws WrongValueException {
        if (maxpos <= 0) {
            throw new WrongValueException("Nonpositive is not allowed: " + maxpos);
        }
        if (this._maxpos != maxpos) {
            if (this._curpos > maxpos) {
                this.setCurpos(maxpos);
            }
            this._maxpos = maxpos;
            this.smartUpdate("maxpos", this._maxpos);
        }
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public int getPageIncrement() {
        return this._pginc;
    }

    public void setPageIncrement(int pginc) throws WrongValueException {
        if (this._pginc != pginc) {
            this._pginc = pginc;
            this.smartUpdate("pageIncrement", this._pginc);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public void setMold(String mold) {
        if (this.isVertical()) {
            if (mold.startsWith("scale")) {
                throw new WrongValueException("Unsupported vertical orient in mold : " + mold);
            }
            super.setMold(mold);
        } else {
            super.setMold(mold);
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onScroll")) {
            ScrollEvent evt = ScrollEvent.getScrollEvent((AuRequest)request);
            int curpos = evt.getPos();
            this._curpos = curpos >= 0 ? curpos : 0;
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onScrolling")) {
            ScrollEvent evt = ScrollEvent.getScrollEvent((AuRequest)request);
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!this._orient.equals("horizontal")) {
            renderer.render("orient", this._orient);
        }
        if (!this._slidingtext.equals("{0}")) {
            renderer.render("slidingtext", this._slidingtext);
        }
        if (this._curpos != 0) {
            renderer.render("curpos", this._curpos);
        }
        if (this._maxpos != 100) {
            renderer.render("maxpos", this._maxpos);
        }
        if (this._pginc >= 0) {
            renderer.render("pageIncrement", this._pginc);
        }
        if (this._name != null) {
            renderer.render("name", this._name);
        }
    }

    static {
        Slider.addClientEvent(Slider.class, (String)"onScroll", (int)8193);
        Slider.addClientEvent(Slider.class, (String)"onScrolling", (int)8192);
    }
}

