/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.ItemRenderer;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selectbox
extends HtmlBasedComponent {
    private String _name;
    private boolean _disabled;
    private int _jsel = -1;
    private int _tabindex;
    private transient ListModel<?> _model;
    private transient ListDataListener _dataListener;
    private transient ItemRenderer<?> _renderer;
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.onInitLaterPosted";
    private transient boolean _childable;
    private transient String[] _tmpdatas;
    private static final ItemRenderer<Object> _defRend;

    public String getZclass() {
        return this._zclass == null ? "z-selectbox" : this._zclass;
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public void setSelectedIndex(int jsel) {
        if (jsel < -1) {
            jsel = -1;
        }
        if (jsel != this._jsel) {
            this._jsel = jsel;
            this.smartUpdate("selectedIndex", jsel);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            this.smartUpdate("tabindex", tabindex);
        }
    }

    public <T> ItemRenderer<T> getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ItemRenderer<?> renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            this.invalidate();
        }
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((ItemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    protected boolean isChildable() {
        return this._childable;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", name);
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    switch (event.getType()) {
                        case 4: {
                            Selectbox.this.doSelectionChanged();
                            return;
                        }
                        case 6: {
                            return;
                        }
                    }
                    Selectbox.this.postOnInitRender();
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    private void doSelectionChanged() {
        Selectable<Object> smodel = this.getSelectableModel();
        if (smodel.isSelectionEmpty()) {
            if (this._jsel >= 0) {
                this.setSelectedIndex(-1);
            }
            return;
        }
        if (this._jsel >= 0 && smodel.isSelected(this._model.getElementAt(this._jsel))) {
            return;
        }
        int sz = this._model.getSize();
        for (int i = 0; i < sz; ++i) {
            if (!smodel.isSelected(this._model.getElementAt(i))) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.setSelectedIndex(-1);
    }

    private Selectable<Object> getSelectableModel() {
        return (Selectable)((Object)this._model);
    }

    public void setModel(ListModel<?> model) {
        if (model != null) {
            if (!(model instanceof Selectable)) {
                throw new UiException(model.getClass() + " must implement " + Selectable.class);
            }
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                }
                this._model = model;
                this.initDataListener();
                this.postOnInitRender();
            }
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            this.invalidate();
        }
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        if (this._model != null) {
            this._tmpdatas = new String[this._model.getSize()];
            boolean old = this._childable;
            try {
                this._childable = true;
                ItemRenderer<?> renderer = this.getRealRenderer();
                Selectable<Object> smodel = this.getSelectableModel();
                this._jsel = -1;
                int sz = this._model.getSize();
                for (int i = 0; i < sz; ++i) {
                    Object value = this._model.getElementAt(i);
                    if (this._jsel < 0 && smodel.isSelected(value)) {
                        this._jsel = i;
                    }
                    this._tmpdatas[i] = renderer.render((Component)this, value, i);
                }
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            finally {
                this._childable = old;
                this.getChildren().clear();
            }
        }
        this.invalidate();
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    public <T> ListModel<T> getModel() {
        return this._model;
    }

    public <T> ItemRenderer<T> getRealRenderer() {
        ItemRenderer<T> renderer = this.getItemRenderer();
        return renderer != null ? renderer : _defRend;
    }

    public void invalidate() {
        this.prepareDatas();
        super.invalidate();
    }

    public void setParent(Component parent) {
        super.setParent(parent);
        if (parent != null) {
            this.prepareDatas();
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        this.prepareDatas();
    }

    private void prepareDatas() {
        if (this._tmpdatas == null && this._model != null && this._model.getSize() > 0) {
            this.postOnInitRender();
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "name", this._name);
        this.render(renderer, "disabled", this.isDisabled());
        renderer.render("selectedIndex", this._jsel);
        if (this._tabindex != 0) {
            renderer.render("tabindex", this._tabindex);
        }
        if (this._tmpdatas != null) {
            this.render(renderer, "items", this._tmpdatas);
            this._tmpdatas = null;
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSelect")) {
            this._jsel = (Integer)request.getData().get("");
            Integer index = (Integer)request.getData().get("");
            LinkedHashSet selObjs = new LinkedHashSet();
            if (index >= 0) {
                selObjs.add(this._model.getElementAt(index));
            }
            if (this._model != null) {
                this.getSelectableModel().setSelection(selObjs);
            }
            Events.postEvent((Event)new SelectEvent("onSelect", (Component)this, null, selObjs, null, (Object)index, 0));
        } else {
            super.service(request, everError);
        }
    }

    public Object clone() {
        Selectbox clone = (Selectbox)((Object)super.clone());
        if (clone._model != null) {
            ListModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (ListModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone.postOnInitRender();
            clone._dataListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        s.writeObject(this._model instanceof Serializable || this._model instanceof Externalizable ? this._model : null);
        this.willSerialize(this._renderer);
        s.writeObject(this._renderer instanceof Serializable || this._renderer instanceof Externalizable ? this._renderer : null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (ListModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (ItemRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        if (this._model != null) {
            this.initDataListener();
        }
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
        if (this._model != null) {
            this.postOnInitRender();
        }
    }

    static {
        Selectbox.addClientEvent(Selectbox.class, (String)"onSelect", (int)8193);
        Selectbox.addClientEvent(Selectbox.class, (String)"onFocus", (int)8192);
        Selectbox.addClientEvent(Selectbox.class, (String)"onBlur", (int)8192);
        _defRend = new ItemRenderer<Object>(){

            @Override
            public String render(final Component owner, final Object data, final int index) {
                Selectbox self = (Selectbox)owner;
                Template tm = self.getTemplate("model");
                if (tm == null) {
                    return Objects.toString((Object)data);
                }
                Component[] items = tm.create(owner, null, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return data;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return data;
                                }

                                public int getIndex() {
                                    return index;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    return ((Selectbox)owner).getModel().getSize();
                                }
                            };
                        }
                        return null;
                    }
                }, null);
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one item, not " + items.length);
                }
                if (!(items[0] instanceof Label)) {
                    throw new UiException("The model template can only support Label component, not " + items[0]);
                }
                items[0].detach();
                return ((Label)items[0]).getValue();
            }
        };
    }
}

