/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.bind.proxy.AbstractCollectionProxy;
import org.zkoss.bind.proxy.ProxyHelper;

public class ListProxy<E>
extends AbstractCollectionProxy<E>
implements List<E> {
    private static final long serialVersionUID = 20141225150833L;
    private Annotation[] _callerAnnots;

    public ListProxy(Collection<E> origin, Annotation[] callerAnnots) {
        super(origin, callerAnnots);
        this._callerAnnots = callerAnnots;
        this.resetFromOrigin();
    }

    @Override
    protected Collection<E> initCache() {
        return new ArrayList(((Collection)this.getOriginObject()).size());
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this._dirty = true;
        return ((List)this.getCache()).addAll(index, c);
    }

    @Override
    public E get(int index) {
        return ((List)this.getCache()).get(index);
    }

    @Override
    public E set(int index, E element) {
        this._dirty = true;
        return ((List)this.getCache()).set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this._dirty = true;
        ((List)this.getCache()).add(index, element);
    }

    @Override
    public E remove(int index) {
        this._dirty = true;
        return ((List)this.getCache()).remove(index);
    }

    @Override
    public int indexOf(Object o) {
        int size = this.size();
        if (o == null) {
            for (int i = 0; i < size; ++i) {
                if (!ListProxy.testEquals(this.get(i), null)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!ListProxy.testEquals(o, this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int size = this.size();
        if (o == null) {
            for (int i = size - 1; i >= 0; --i) {
                if (!ListProxy.testEquals(this.get(i), null)) continue;
                return i;
            }
        } else {
            for (int i = size - 1; i >= 0; --i) {
                if (!ListProxy.testEquals(o, this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return ((List)this.getCache()).listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return ((List)this.getCache()).listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return ProxyHelper.createProxyIfAny(((List)this.getCache()).subList(fromIndex, toIndex), this._callerAnnots);
    }
}

