/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.zkoss.lang.Objects;
import org.zkoss.xml.XMLs;
import org.zkoss.zhtml.impl.PageRenderer;
import org.zkoss.zhtml.impl.TagRenderContext;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ext.Includer;
import org.zkoss.zk.ui.ext.RawId;
import org.zkoss.zk.ui.ext.render.DirectContent;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.StringPropertyAccess;

public class Text
extends AbstractComponent
implements RawId {
    private String _value = "";
    private boolean _encode = true;
    private static HashMap<String, PropertyAccess> _properties = new HashMap(2);

    public Text() {
    }

    public Text(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            if (!this.invalidateParent()) {
                this.smartUpdate("value", this._value);
            } else {
                this.invalidate();
            }
        }
    }

    private boolean isIdRequired() {
        Page p = this.getPage();
        return p == null || !this.isVisible() || this.getId().length() > 0 || !Text.isRawLabel(p);
    }

    private static boolean isRawLabel(Page page) {
        LanguageDefinition langdef = page.getLanguageDefinition();
        return langdef != null && langdef.isRawLabel();
    }

    public boolean isEncode() {
        return this._encode;
    }

    public void setEncode(boolean encode) {
        this._encode = encode;
    }

    public String getWidgetClass() {
        return "zhtml.Text";
    }

    private boolean invalidateParent() {
        return !(this.getParent() instanceof Includer) && !this.isIdRequired();
    }

    public void setParent(Component parent) {
        Component old = this.getParent();
        if (old != null && old != parent && this.invalidateParent()) {
            old.invalidate();
        }
        super.setParent(parent);
        if (parent != null && old != parent && this.invalidateParent()) {
            parent.invalidate();
        }
    }

    public void invalidate() {
        if (!this.invalidateParent()) {
            super.invalidate();
        } else if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public void redraw(Writer out) throws IOException {
        TagRenderContext rc;
        Execution exec = Executions.getCurrent();
        if (!HtmlPageRenders.isDirectContent((Execution)exec)) {
            super.redraw(out);
            return;
        }
        boolean idRequired = this.isIdRequired();
        if (idRequired) {
            out.write("<span id=\"");
            out.write(this.getUuid());
            out.write("\">");
        }
        out.write(this._encode ? XMLs.encodeText((String)this._value) : this._value);
        if (idRequired) {
            out.write("</span>");
        }
        if ((rc = PageRenderer.getTagRenderContext(exec)) != null) {
            rc.renderBegin((Component)this, this.getClientEvents(), this.getSpecialRendererOutput((Component)this), false);
            rc.renderEnd((Component)this);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "value", this._value);
        this.render(renderer, "idRequired", this.isIdRequired());
        if (!this._encode) {
            renderer.render("encode", false);
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    static {
        _properties.put("encode", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((Text)cmp).setEncode(value);
            }

            public Boolean getValue(Component cmp) {
                return ((Text)cmp).isEncode();
            }
        });
        _properties.put("value", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((Text)cmp).setValue(value);
            }

            public String getValue(Component cmp) {
                return ((Text)cmp).getValue();
            }
        });
    }

    protected class ExtraCtrl
    implements DirectContent {
        protected ExtraCtrl() {
        }
    }
}

