/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.gen;

import java.util.HashMap;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;

public class Exim {
    private final ClientApi api;

    public Exim(ClientApi api) {
        this.api = api;
    }

    public ApiResponse importHar(String filepath) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filePath", filepath);
        return this.api.callApi("exim", "action", "importHar", map);
    }

    public ApiResponse importUrls(String filepath) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filePath", filepath);
        return this.api.callApi("exim", "action", "importUrls", map);
    }

    public ApiResponse importZapLogs(String filepath) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filePath", filepath);
        return this.api.callApi("exim", "action", "importZapLogs", map);
    }

    public ApiResponse importModsec2Logs(String filepath) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filePath", filepath);
        return this.api.callApi("exim", "action", "importModsec2Logs", map);
    }

    public ApiResponse exportSitesTree(String filepath) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filePath", filepath);
        return this.api.callApi("exim", "action", "exportSitesTree", map);
    }

    public ApiResponse pruneSitesTree(String filepath) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filePath", filepath);
        return this.api.callApi("exim", "action", "pruneSitesTree", map);
    }

    public byte[] exportHar(String baseurl, String start, String count) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (baseurl != null) {
            map.put("baseurl", baseurl);
        }
        if (start != null) {
            map.put("start", start);
        }
        if (count != null) {
            map.put("count", count);
        }
        return this.api.callApiOther("exim", "other", "exportHar", map);
    }

    public byte[] exportHarById(String ids) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ids", ids);
        return this.api.callApiOther("exim", "other", "exportHarById", map);
    }

    public byte[] sendHarRequest(String request, String followredirects) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("request", request);
        if (followredirects != null) {
            map.put("followRedirects", followredirects);
        }
        return this.api.callApiOther("exim", "other", "sendHarRequest", map);
    }
}

