/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.common.MediaTypeQuery;
import org.zalando.logbook.core.CompactingXmlBodyFilter;
import org.zalando.logbook.core.DefaultFilters;
import org.zalando.logbook.core.QueryFilters;

@API(status=API.Status.STABLE)
public final class BodyFilters {
    private BodyFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static BodyFilter defaultValue() {
        return DefaultFilters.defaultValues(BodyFilter.class).stream().reduce(BodyFilters.oauthRequest(), BodyFilter::merge);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter oauthRequest() {
        HashSet<String> properties = new HashSet<String>();
        properties.add("client_secret");
        properties.add("password");
        properties.add("refresh_token");
        return BodyFilters.replaceFormUrlEncodedProperty(properties, "XXX");
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter replaceFormUrlEncodedProperty(Set<String> properties, String replacement) {
        Predicate formUrlEncoded = MediaTypeQuery.compile((String)"application/x-www-form-urlencoded", (String[])new String[0]);
        QueryFilter delegate = QueryFilters.replaceQuery(properties::contains, replacement);
        return (contentType, body) -> formUrlEncoded.test(contentType) ? delegate.filter(body) : body;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter truncate(int maxSize) {
        return (contentType, body) -> body.length() <= maxSize ? body : body.substring(0, maxSize) + "...";
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static BodyFilter compactXml() {
        return new CompactingXmlBodyFilter();
    }
}

