/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.event.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.analytics.spark.event.EventStreamDataStore;
import org.wso2.carbon.analytics.spark.event.EventingTask;
import org.wso2.carbon.analytics.spark.event.SparkEventingTaskLocationResolver;
import org.wso2.carbon.analytics.spark.event.internal.ServiceHolder;
import org.wso2.carbon.analytics.spark.event.internal.SparkEventingPublisherManagementService;
import org.wso2.carbon.event.processor.manager.core.EventManagementService;
import org.wso2.carbon.event.processor.manager.core.Manager;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.service.TaskService;

public class EventingComponent {
    private static final Log log = LogFactory.getLog(EventingComponent.class);

    protected void activate(ComponentContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activating Spark Eventing");
        }
        ServiceHolder.setEventPublisherManagementService(new SparkEventingPublisherManagementService());
        ServiceHolder.getEventManagementService().subscribe((Manager)ServiceHolder.getEventPublisherManagementService());
        this.initializeSparkEventingTask();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Spark Eventing Activated");
        }
    }

    private void initializeSparkEventingTask() {
        try {
            if (this.isReceiverNode() && !this.isSparkEventingTaskDisabled()) {
                EventStreamDataStore.initStore();
                ServiceHolder.getTaskService().registerTaskType("ANALYTICS_SPARK_EVENTING");
                TaskInfo.TriggerInfo triggerInfo = new TaskInfo.TriggerInfo(null, null, 10000L, -1);
                triggerInfo.setDisallowConcurrentExecution(true);
                TaskInfo taskInfo = new TaskInfo("STORE_EVENT_ROUTER_TASK", EventingTask.class.getCanonicalName(), null, triggerInfo);
                taskInfo.setLocationResolverClass(SparkEventingTaskLocationResolver.class.getCanonicalName());
                TaskManager tm = ServiceHolder.getTaskService().getTaskManager("ANALYTICS_SPARK_EVENTING");
                tm.registerTask(taskInfo);
                tm.rescheduleTask(taskInfo.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while scheduling Spark eventing task: " + e.getMessage(), e);
        }
    }

    protected void deactivate(ComponentContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivating Spark Eventing");
        }
    }

    protected void setEventStreamService(EventStreamService eventStreamService) {
        ServiceHolder.setEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        ServiceHolder.setEventStreamService(null);
    }

    private boolean isReceiverNode() {
        String propVal = System.getProperty("disableEventSink");
        if (propVal == null) {
            return true;
        }
        return !Boolean.parseBoolean(propVal);
    }

    private boolean isSparkEventingTaskDisabled() {
        String propVal = System.getProperty("disableSparkEventingTask");
        if (propVal == null) {
            return false;
        }
        return Boolean.parseBoolean(propVal);
    }

    protected void setTaskService(TaskService taskService) {
        ServiceHolder.setTaskService(taskService);
    }

    protected void unsetTaskService(TaskService taskService) {
        ServiceHolder.setTaskService(null);
    }

    protected void setEventManagementService(EventManagementService eventManagementService) {
        ServiceHolder.setEventManagementService(eventManagementService);
    }

    protected void unsetEventManagementService(EventManagementService eventManagementService) {
        ServiceHolder.setEventManagementService(null);
    }
}

