/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.event;

import java.io.Serializable;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsCommonUtils;
import org.wso2.carbon.analytics.spark.core.util.CarbonScalaUtils;
import org.wso2.carbon.analytics.spark.event.EventIteratorFunction;
import scala.Function1;
import scala.reflect.ClassTag$;

public class StreamRelation
extends BaseRelation
implements InsertableRelation,
Serializable {
    private static final long serialVersionUID = 1628290158392312871L;
    private SQLContext sqlContext;
    private StructType schema;
    private String streamId;
    private int tenantId;
    private boolean globalTenantAccess;

    public StreamRelation(int tenantId, SQLContext sqlContext, String streamId, String payloadString, boolean globalTenantAccess) {
        this.tenantId = tenantId;
        this.sqlContext = sqlContext;
        this.streamId = streamId;
        this.globalTenantAccess = globalTenantAccess;
        this.schema = new StructType(this.extractFieldsFromString(payloadString));
    }

    public void insert(DataFrame data, boolean b) {
        for (int i = 0; i < data.rdd().partitions().length; ++i) {
            data.sqlContext().sparkContext().runJob(data.rdd(), (Function1)new EventIteratorFunction(this.tenantId, this.streamId, data.schema(), this.globalTenantAccess), CarbonScalaUtils.getNumberSeq((int)i, (int)(i + 1)), false, ClassTag$.MODULE$.Unit());
        }
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        return this.schema;
    }

    private StructField[] extractFieldsFromString(String payloadString) {
        String[] strFields = payloadString.split(",");
        StructField[] resFields = new StructField[strFields.length];
        for (int i = 0; i < strFields.length; ++i) {
            StructField field;
            String[] strFieldTokens = strFields[i].trim().split(" ");
            String name = strFieldTokens[0].trim();
            String type = strFieldTokens[1].trim().toLowerCase();
            resFields[i] = field = new StructField(name, AnalyticsCommonUtils.stringToDataType((String)type), true, Metadata.empty());
        }
        return resFields;
    }
}

