/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.event;

import com.hazelcast.core.HazelcastInstance;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.dataservice.core.AnalyticsServiceHolder;
import org.wso2.carbon.analytics.spark.event.internal.ServiceHolder;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskLocationResolver;
import org.wso2.carbon.ntask.core.TaskServiceContext;

public class SparkEventingTaskLocationResolver
implements TaskLocationResolver {
    private static final Log log = LogFactory.getLog(SparkEventingTaskLocationResolver.class);

    public void init(Map<String, String> props) throws TaskException {
    }

    public int getLocation(TaskServiceContext ctx, TaskInfo taskInfo) throws TaskException {
        int myNodeLocation = this.extractMyNodeLocation(ctx);
        if (log.isDebugEnabled()) {
            log.debug((Object)("My Location [" + myNodeLocation + "]: " + ctx.getServerAddress(myNodeLocation)));
        }
        int result = ServiceHolder.getEventPublisherManagementService().isDrop() ? myNodeLocation + 1 : myNodeLocation;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolved Location: " + result));
        }
        return result;
    }

    private int extractMyNodeLocation(TaskServiceContext ctx) {
        int count = ctx.getServerCount();
        for (int i = 0; i < count; ++i) {
            if (!this.isMyNode(ctx.getServerAddress(i))) continue;
            return i;
        }
        return 0;
    }

    private boolean isMyNode(InetSocketAddress addr) {
        HazelcastInstance hz = AnalyticsServiceHolder.getHazelcastInstance();
        if (hz == null) {
            return false;
        }
        return hz.getCluster().getLocalMember().getSocketAddress().equals(addr);
    }
}

