/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.event;

import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.RelationProvider;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.spark.event.EventStreamDataStore;
import org.wso2.carbon.analytics.spark.event.StreamRelation;
import scala.Function0;
import scala.collection.immutable.Map;
import scala.runtime.AbstractFunction0;

public class EventStreamProvider
implements RelationProvider {
    private static final String DEFAULT_VERSION = "1.0.0";
    private int tenantId;
    private String streamName;
    private String version;
    private String payload;
    private boolean globalTenantAccess;

    public EventStreamProvider() {
        try {
            EventStreamDataStore.initStore();
        }
        catch (AnalyticsException e) {
            throw new RuntimeException("Error in creating event stream provider: " + e.getMessage(), e);
        }
    }

    public StreamRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        this.setParameters(parameters);
        return new StreamRelation(this.tenantId, sqlContext, this.getStreamId(this.streamName, this.version), this.payload, this.globalTenantAccess);
    }

    private void setParameters(Map<String, String> parameters) {
        this.tenantId = Integer.parseInt(this.extractValuesFromMap("tenantId", parameters, "-1234"));
        this.streamName = this.extractValuesFromMap("streamName", parameters, "");
        this.version = this.extractValuesFromMap("version", parameters, DEFAULT_VERSION);
        this.payload = this.extractValuesFromMap("payload", parameters, "");
        this.globalTenantAccess = this.tenantId == -1234 && Boolean.parseBoolean(this.extractValuesFromMap("globalTenantAccess", parameters, String.valueOf(false)));
    }

    private String getStreamId(String streamName, String version) {
        return streamName + ":" + version;
    }

    private String extractValuesFromMap(String key, Map<String, String> map, final String defaultVal) {
        return (String)map.getOrElse((Object)key, (Function0)new AbstractFunction0<String>(){

            public String apply() {
                return defaultVal;
            }
        });
    }
}

