/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.spark.admin.AnalyticsProcessorAdminException;
import org.wso2.carbon.analytics.spark.admin.dto.AnalyticsQueryResultDto;
import org.wso2.carbon.analytics.spark.admin.dto.AnalyticsScheduledScriptDto;
import org.wso2.carbon.analytics.spark.admin.dto.AnalyticsScriptDto;
import org.wso2.carbon.analytics.spark.admin.internal.AnalyticsResultConverter;
import org.wso2.carbon.analytics.spark.admin.internal.ServiceHolder;
import org.wso2.carbon.analytics.spark.admin.util.AnalyticsProcessorUtils;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsExecutionException;
import org.wso2.carbon.analytics.spark.core.exception.AnalyticsPersistenceException;
import org.wso2.carbon.analytics.spark.core.util.AnalyticsScript;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;

public class AnalyticsProcessorAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(AnalyticsProcessorAdminService.class);

    public void saveScript(String scriptName, String scriptContent, String cronExpression) throws AnalyticsProcessorAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            ServiceHolder.getAnalyticsProcessorService().saveScript(tenantId, scriptName, scriptContent, cronExpression);
        }
        catch (AnalyticsPersistenceException e) {
            log.error((Object)("Error occurred when persisting the script. " + e.getMessage()), (Throwable)e);
            throw new AnalyticsProcessorAdminException("Error occurred when persisting the script. " + e.getMessage(), e);
        }
    }

    public void pauseAllScripts() throws AnalyticsProcessorAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            ServiceHolder.getAnalyticsProcessorService().pauseAllScripts(tenantId);
        }
        catch (AnalyticsExecutionException e) {
            throw new AnalyticsProcessorAdminException(e.getMessage(), e);
        }
    }

    public void resumeAllScripts() throws AnalyticsProcessorAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            ServiceHolder.getAnalyticsProcessorService().resumeAllScripts(tenantId);
        }
        catch (AnalyticsExecutionException e) {
            throw new AnalyticsProcessorAdminException(e.getMessage(), e);
        }
    }

    public AnalyticsScheduledScriptDto[] getScheduledTaskStatuses() throws AnalyticsProcessorAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            List taskInfoList = ServiceHolder.getAnalyticsProcessorService().getScheduledTasks();
            ArrayList<AnalyticsScheduledScriptDto> scheduledScriptDtos = new ArrayList<AnalyticsScheduledScriptDto>();
            for (TaskInfo task : taskInfoList) {
                if (!((String)task.getProperties().get("TENANT_ID")).equals(String.valueOf(tenantId))) continue;
                scheduledScriptDtos.add(this.getAnalyticsScheduledScriptDto(task, org.wso2.carbon.analytics.spark.core.internal.ServiceHolder.getTaskManager().getTaskState(task.getName()).toString()));
            }
            return scheduledScriptDtos.toArray(new AnalyticsScheduledScriptDto[scheduledScriptDtos.size()]);
        }
        catch (AnalyticsExecutionException | TaskException e) {
            log.error((Object)(e.getMessage() + "tenant " + tenantId), e);
            throw new AnalyticsProcessorAdminException(e.getMessage(), e);
        }
    }

    public void saveScriptContent(String scriptName, String scriptContent) throws AnalyticsProcessorAdminException {
        this.saveScript(scriptName, scriptContent, null);
    }

    public void deleteScript(String scriptName) throws AnalyticsProcessorAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            ServiceHolder.getAnalyticsProcessorService().deleteScript(tenantId, scriptName);
        }
        catch (AnalyticsPersistenceException e) {
            log.error((Object)("Error while deleting the script : " + scriptName), (Throwable)e);
            throw new AnalyticsProcessorAdminException("Error while deleting the script : " + scriptName, e);
        }
    }

    public void updateScriptContent(String scriptName, String scriptContent) throws AnalyticsProcessorAdminException {
        this.updateScript(scriptName, scriptContent, "DEFAULT");
    }

    public void updateScriptTask(String scriptName, String cronExpression) throws AnalyticsProcessorAdminException {
        this.updateScript(scriptName, null, cronExpression);
    }

    public void updateScript(String scriptName, String scriptContent, String cronExpression) throws AnalyticsProcessorAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        AnalyticsScriptDto scriptDto = this.getScript(scriptName);
        try {
            ServiceHolder.getAnalyticsProcessorService().updateScript(tenantId, scriptName, scriptContent, cronExpression);
        }
        catch (Exception e) {
            log.error((Object)("Error while updating the script : " + scriptName), (Throwable)e);
            try {
                ServiceHolder.getAnalyticsProcessorService().updateScript(tenantId, scriptName, scriptDto.getScriptContent(), scriptDto.getCronExpression());
            }
            catch (AnalyticsPersistenceException e1) {
                throw new AnalyticsProcessorAdminException("Error while reverting to previous state for : " + scriptName, e);
            }
            throw new AnalyticsProcessorAdminException("Error while updating the script : " + scriptName, e);
        }
    }

    public AnalyticsScriptDto[] getAllScripts() throws AnalyticsProcessorAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            List analyticsScripts = ServiceHolder.getAnalyticsProcessorService().getAllScripts(tenantId);
            AnalyticsScriptDto[] scriptDtos = new AnalyticsScriptDto[analyticsScripts.size()];
            int index = 0;
            for (AnalyticsScript script : analyticsScripts) {
                scriptDtos[index] = this.getAnalyticsScriptDto(script);
                ++index;
            }
            return scriptDtos;
        }
        catch (AnalyticsPersistenceException e) {
            log.error((Object)("Error while retrieving all scripts for tenant Id : " + tenantId), (Throwable)e);
            throw new AnalyticsProcessorAdminException("Error while retrieving all scripts for tenant Id : " + tenantId);
        }
    }

    public AnalyticsScriptDto getScript(String name) throws AnalyticsProcessorAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            AnalyticsScript script = ServiceHolder.getAnalyticsProcessorService().getScript(tenantId, name);
            return this.getAnalyticsScriptDto(script);
        }
        catch (AnalyticsPersistenceException ex) {
            log.error((Object)("Error while retrieving the script : " + name), (Throwable)ex);
            throw new AnalyticsProcessorAdminException("Error while retrieving the script : " + name, ex);
        }
    }

    private AnalyticsScriptDto getAnalyticsScriptDto(AnalyticsScript analyticsScript) {
        AnalyticsScriptDto scriptDto = new AnalyticsScriptDto(analyticsScript.getName());
        scriptDto.setScriptContent(analyticsScript.getScriptContent());
        scriptDto.setCronExpression(analyticsScript.getCronExpression());
        scriptDto.setEditable(analyticsScript.isEditable());
        return scriptDto;
    }

    private AnalyticsScheduledScriptDto getAnalyticsScheduledScriptDto(TaskInfo taskInfo, String status) {
        AnalyticsScheduledScriptDto analyticsScheduledScriptDto = new AnalyticsScheduledScriptDto();
        analyticsScheduledScriptDto.setName(taskInfo.getName());
        analyticsScheduledScriptDto.setStatus(status);
        return analyticsScheduledScriptDto;
    }

    public AnalyticsQueryResultDto[] executeScript(String scriptName) throws AnalyticsProcessorAdminException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            AnalyticsScript script = ServiceHolder.getAnalyticsProcessorService().getScript(tenantId, scriptName);
            return this.execute(script.getScriptContent());
        }
        catch (AnalyticsPersistenceException e) {
            log.error((Object)("Error while running the script : " + scriptName), (Throwable)e);
            throw new AnalyticsProcessorAdminException("Error while running the script : " + scriptName, e);
        }
    }

    public void executeScriptInBackground(String scriptName) throws AnalyticsProcessorAdminException {
        final int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            final AnalyticsScript script = ServiceHolder.getAnalyticsProcessorService().getScript(tenantId, scriptName);
            ExecutorService executor = AnalyticsProcessorUtils.getExecutorServiceInstance();
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!AnalyticsProcessorUtils.getRunningScriptsMap().containsKey(script.getName())) {
                            AnalyticsProcessorUtils.getRunningScriptsMap().put(script.getName(), script.getName());
                            log.info((Object)("Started executing the script : " + script.getName()));
                            AnalyticsProcessorAdminService.this.execute(script.getScriptContent(), tenantId);
                        }
                    }
                    catch (AnalyticsProcessorAdminException e) {
                        log.error((Object)("Error while running the script : " + script.getName()), (Throwable)e);
                    }
                    finally {
                        AnalyticsProcessorUtils.getRunningScriptsMap().remove(script.getName());
                    }
                }
            });
        }
        catch (AnalyticsPersistenceException e) {
            log.error((Object)("Error while running the script : " + scriptName), (Throwable)e);
            throw new AnalyticsProcessorAdminException("Error while running the script : " + scriptName, e);
        }
    }

    public AnalyticsQueryResultDto[] execute(String scriptContent) throws AnalyticsProcessorAdminException {
        if (scriptContent != null && !scriptContent.trim().isEmpty()) {
            String[] queries = ServiceHolder.getAnalyticsProcessorService().getQueries(scriptContent);
            AnalyticsQueryResultDto[] results = new AnalyticsQueryResultDto[queries.length];
            int index = 0;
            for (String query : queries) {
                AnalyticsQueryResultDto queryResult = this.executeQuery(query);
                if (queryResult == null) {
                    queryResult = new AnalyticsQueryResultDto(query);
                }
                results[index] = queryResult;
                ++index;
            }
            return results;
        }
        log.error((Object)("No queries provided to execute at tenant id :" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()));
        throw new AnalyticsProcessorAdminException("No queries provided to execute.");
    }

    public void executeInBackground(final String scriptContent) throws AnalyticsProcessorAdminException {
        final int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (scriptContent == null || scriptContent.trim().isEmpty()) {
            log.error((Object)("No queries provided to execute at tenant id :" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()));
            throw new AnalyticsProcessorAdminException("No queries provided to execute.");
        }
        ExecutorService executor = AnalyticsProcessorUtils.getExecutorServiceInstance();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] queries;
                    log.info((Object)"Started executing the script...");
                    for (String query : queries = ServiceHolder.getAnalyticsProcessorService().getQueries(scriptContent)) {
                        AnalyticsProcessorAdminService.this.executeQuery(query, tenantId);
                    }
                }
                catch (AnalyticsProcessorAdminException e) {
                    log.error((Object)("Error while running the scriptContent at tenant id  : " + tenantId), (Throwable)e);
                }
            }
        });
    }

    private AnalyticsQueryResultDto[] execute(String scriptContent, int tenantId) throws AnalyticsProcessorAdminException {
        if (scriptContent != null && !scriptContent.trim().isEmpty()) {
            String[] queries = ServiceHolder.getAnalyticsProcessorService().getQueries(scriptContent);
            AnalyticsQueryResultDto[] results = new AnalyticsQueryResultDto[queries.length];
            int index = 0;
            for (String query : queries) {
                AnalyticsQueryResultDto queryResult = this.executeQuery(query, tenantId);
                if (queryResult == null) {
                    queryResult = new AnalyticsQueryResultDto(query);
                }
                results[index] = queryResult;
                ++index;
            }
            return results;
        }
        log.error((Object)("No queries provided to execute at tenant id :" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()));
        throw new AnalyticsProcessorAdminException("No queries provided to execute.");
    }

    public AnalyticsQueryResultDto executeQuery(String query) throws AnalyticsProcessorAdminException {
        if (query != null && !query.trim().isEmpty()) {
            try {
                int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
                AnalyticsQueryResultDto queryResult = AnalyticsResultConverter.convertResults(ServiceHolder.getAnalyticsProcessorService().executeQuery(tenantId, query));
                if (queryResult != null) {
                    queryResult.setQuery(query);
                }
                return queryResult;
            }
            catch (AnalyticsExecutionException e) {
                log.error((Object)("Error while executing query : " + query), (Throwable)e);
                throw new AnalyticsProcessorAdminException(e);
            }
        }
        log.error((Object)("No queries provided to execute at tenant id :" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()));
        throw new AnalyticsProcessorAdminException("No queries provided to execute.");
    }

    private AnalyticsQueryResultDto executeQuery(String query, int tenantId) throws AnalyticsProcessorAdminException {
        if (query != null && !query.trim().isEmpty()) {
            try {
                AnalyticsQueryResultDto queryResult = AnalyticsResultConverter.convertResults(ServiceHolder.getAnalyticsProcessorService().executeQuery(tenantId, query));
                if (queryResult != null) {
                    queryResult.setQuery(query);
                }
                return queryResult;
            }
            catch (AnalyticsExecutionException e) {
                log.error((Object)("Error while executing query : " + query), (Throwable)e);
                throw new AnalyticsProcessorAdminException("Error while executing query : " + query, e);
            }
        }
        log.error((Object)("No queries provided to execute at tenant id :" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()));
        throw new AnalyticsProcessorAdminException("No queries provided to execute.");
    }

    public boolean isAnalyticsExecutionEnabled() {
        return ServiceHolder.getAnalyticsProcessorService().isAnalyticsExecutionEnabled();
    }

    public boolean isAnalyticsScriptExecuting(String scriptName) {
        return AnalyticsProcessorUtils.getRunningScriptsMap().containsKey(scriptName);
    }

    public boolean isAnalyticsTaskExecuting(String scriptName) throws AnalyticsProcessorAdminException {
        try {
            return ServiceHolder.getAnalyticsProcessorService().isAnalyticsTaskExecuting(scriptName);
        }
        catch (AnalyticsExecutionException e) {
            throw new AnalyticsProcessorAdminException("Error while retrieving the status of the task : " + scriptName, e);
        }
    }
}

