/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AnalyticsAPIAuthenticator {
    private static Log log = LogFactory.getLog(AnalyticsAPIAuthenticator.class);
    private static final String SESSION_CACHE_NAME = "ANALYTICS_API_SERVICE_SESSION_CACHE";
    private Map<String, Boolean> sessionIds = ServiceHolder.getHazelcastInstance() != null ? ServiceHolder.getHazelcastInstance().getMap("ANALYTICS_API_SERVICE_SESSION_CACHE") : new HashMap<String, Boolean>();

    public String authenticate(String username, String password) throws AnalyticsAPIAuthenticationException {
        if (username == null || username.trim().isEmpty()) {
            this.logAndThrowAuthException("Username is not provided!");
        }
        if (password == null || password.trim().isEmpty()) {
            this.logAndThrowAuthException("Password is not provided!");
        }
        String userName = MultitenantUtils.getTenantAwareUsername((String)username);
        if (MultitenantUtils.getTenantDomain((String)username).equals("carbon.super")) {
            boolean authenticated = ServiceHolder.getAuthenticationService().authenticate(userName, password);
            if (authenticated) {
                try {
                    boolean authorized = ServiceHolder.getRealmService().getTenantUserRealm(-1234).getAuthorizationManager().isUserAuthorized(username, "/permission/admin/manage/analytics/api", "ui.execute");
                    if (authorized) {
                        String sessionId = UUID.randomUUID().toString();
                        this.sessionIds.put(sessionId, Boolean.TRUE);
                        return sessionId;
                    }
                    this.logAndThrowAuthException("User :" + userName + " don't have necessary permissions " + "to connect to remote analytics API.");
                }
                catch (UserStoreException e) {
                    this.logAndThrowAuthException("User :" + userName + " don't have necessary permissions " + "to connect to remote analytics API.");
                }
            } else {
                this.logAndThrowAuthException("Login failed for user :" + userName);
            }
        } else {
            this.logAndThrowAuthException("Only super tenant users is authenticated to use the service!");
        }
        return null;
    }

    private void logAndThrowAuthException(String message) throws AnalyticsAPIAuthenticationException {
        log.error((Object)message);
        throw new AnalyticsAPIAuthenticationException(message);
    }

    public void validateSessionId(String sessionId) throws AnalyticsAPIAuthenticationException {
        if (this.sessionIds.get(sessionId) == null || !this.sessionIds.get(sessionId).booleanValue()) {
            this.logAndThrowAuthException("Unauthenticated session Id : " + sessionId);
        }
    }
}

