/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;

public class AnalyticsTableSchemaProcessor
extends HttpServlet {
    private static final long serialVersionUID = 2072033492230159580L;
    private static final Log log = LogFactory.getLog(AnalyticsTableSchemaProcessor.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            int tenantId = -1;
            if (!securityEnabled) {
                tenantId = Integer.parseInt(req.getParameter("tenant_id"));
            }
            String userName = req.getParameter("username");
            if (operation != null && operation.trim().equalsIgnoreCase("__set_schema_opr")) {
                String tableName = req.getParameter("table_name");
                Object analyticsSchemeObj = GenericUtils.deserializeObject((InputStream)req.getInputStream());
                if (analyticsSchemeObj != null && analyticsSchemeObj instanceof AnalyticsSchema) {
                    AnalyticsSchema schema = (AnalyticsSchema)analyticsSchemeObj;
                    try {
                        if (!securityEnabled) {
                            ServiceHolder.getAnalyticsDataService().setTableSchema(tenantId, tableName, schema);
                        } else {
                            ServiceHolder.getSecureAnalyticsDataService().setTableSchema(userName, tableName, schema);
                        }
                        resp.setStatus(200);
                    }
                    catch (AnalyticsException e) {
                        resp.sendError(417, e.getMessage());
                    }
                } else {
                    resp.sendError(406, "unexpected content passed with the request! Expected analytics schema but found " + analyticsSchemeObj);
                }
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            int tenantId = -1;
            if (!securityEnabled) {
                tenantId = Integer.parseInt(req.getParameter("tenant_id"));
            }
            String userName = req.getParameter("username");
            if (operation != null && operation.trim().equalsIgnoreCase("__get_schema_opr")) {
                String tableName = req.getParameter("table_name");
                try {
                    AnalyticsSchema schema = !securityEnabled ? ServiceHolder.getAnalyticsDataService().getTableSchema(tenantId, tableName) : ServiceHolder.getSecureAnalyticsDataService().getTableSchema(userName, tableName);
                    resp.getOutputStream().write(GenericUtils.serializeObject((Object)schema));
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }
}

