/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;

public class AnalyticsTableProcessor
extends HttpServlet {
    private static final long serialVersionUID = -8592513244152763351L;
    private static final Log log = LogFactory.getLog(AnalyticsTableProcessor.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            int tenantIdParam = -1;
            if (!securityEnabled) {
                tenantIdParam = Integer.parseInt(req.getParameter("tenant_id"));
            }
            String userName = req.getParameter("username");
            if (operation != null && operation.trim().equalsIgnoreCase("__table_exists_opr")) {
                String tableName = req.getParameter("table_name");
                try {
                    boolean tableExists = !securityEnabled ? ServiceHolder.getAnalyticsDataService().tableExists(tenantIdParam, tableName) : ServiceHolder.getSecureAnalyticsDataService().tableExists(userName, tableName);
                    PrintWriter output = resp.getWriter();
                    output.append("__tableExists").append(":").append(String.valueOf(tableExists));
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else if (operation != null && operation.trim().equalsIgnoreCase("__list_tables_opr")) {
                try {
                    List tableNames = !securityEnabled ? ServiceHolder.getAnalyticsDataService().listTables(tenantIdParam) : ServiceHolder.getSecureAnalyticsDataService().listTables(userName);
                    resp.getOutputStream().write(GenericUtils.serializeObject((Object)tableNames));
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            int tenantId = -1;
            if (!securityEnabled) {
                tenantId = Integer.parseInt(req.getParameter("tenant_id"));
            }
            String userName = req.getParameter("username");
            if (operation != null && operation.trim().equalsIgnoreCase("__create_table_opr")) {
                String tableName = req.getParameter("table_name");
                String recordStoreName = req.getParameter("record_store_name");
                try {
                    if (!securityEnabled) {
                        if (recordStoreName == null) {
                            ServiceHolder.getAnalyticsDataService().createTable(tenantId, tableName);
                        } else {
                            ServiceHolder.getAnalyticsDataService().createTable(tenantId, recordStoreName, tableName);
                        }
                    } else if (recordStoreName == null) {
                        ServiceHolder.getSecureAnalyticsDataService().createTable(userName, tableName);
                    } else {
                        ServiceHolder.getSecureAnalyticsDataService().createTable(userName, recordStoreName, tableName);
                    }
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else if (operation != null && operation.trim().equalsIgnoreCase("__create_if_not_exists_table_opr")) {
                String tableName = req.getParameter("table_name");
                String recordStoreName = req.getParameter("record_store_name");
                try {
                    if (!securityEnabled) {
                        ServiceHolder.getAnalyticsDataService().createTableIfNotExists(tenantId, recordStoreName, tableName);
                    } else {
                        ServiceHolder.getSecureAnalyticsDataService().createTableIfNotExists(userName, recordStoreName, tableName);
                    }
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with post request!");
                log.error((Object)("unsupported operation performed : " + operation + " with post request!"));
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            int tenantId = -1;
            if (!securityEnabled) {
                tenantId = Integer.parseInt(req.getParameter("tenant_id"));
            }
            String userName = req.getParameter("username");
            if (operation != null && operation.trim().equalsIgnoreCase("__delete_table_opr")) {
                String tableName = req.getParameter("table_name");
                try {
                    if (!securityEnabled) {
                        ServiceHolder.getAnalyticsDataService().deleteTable(tenantId, tableName);
                    } else {
                        ServiceHolder.getSecureAnalyticsDataService().deleteTable(userName, tableName);
                    }
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with post request!");
                log.error((Object)("unsupported operation performed : " + operation + " with post request!"));
            }
        }
    }
}

