/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;

public class AnalyticsServiceProcessor
extends HttpServlet {
    private static final long serialVersionUID = -1426603086300914710L;
    private static final Log log = LogFactory.getLog(AnalyticsServiceProcessor.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            if (operation != null && operation.trim().equalsIgnoreCase("__destroy_opr")) {
                try {
                    ServiceHolder.getAnalyticsDataService().destroy();
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with post request!");
                log.error((Object)("unsupported operation performed : " + operation + " with post request!"));
            }
        }
    }
}

