/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.dataservice.commons.AggregateField;
import org.wso2.carbon.analytics.dataservice.commons.AggregateRequest;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDrillDownRequest;
import org.wso2.carbon.analytics.dataservice.commons.CategoryDrillDownRequest;
import org.wso2.carbon.analytics.dataservice.commons.SortByField;
import org.wso2.carbon.analytics.dataservice.commons.SubCategories;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsIterator;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;

public class AnalyticsSearchProcessor
extends HttpServlet {
    private static final long serialVersionUID = 1519852648874078342L;
    private static final Log log = LogFactory.getLog(AnalyticsSearchProcessor.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            int tenantIdParam = -1;
            if (!securityEnabled) {
                tenantIdParam = Integer.parseInt(req.getParameter("tenant_id"));
            }
            String userName = req.getParameter("username");
            String tableName = req.getParameter("table_name");
            String query = req.getParameter("query");
            if (operation != null && operation.trim().equalsIgnoreCase("__search_opr")) {
                int start = Integer.parseInt(req.getParameter("start"));
                int count = Integer.parseInt(req.getParameter("count"));
                Type sortByFieldType = new TypeToken<List<SortByField>>(){}.getType();
                Gson gson = new Gson();
                List sortByFields = (List)gson.fromJson(req.getParameter("sortByFields"), sortByFieldType);
                try {
                    List searchResult = !securityEnabled ? ServiceHolder.getAnalyticsDataService().search(tenantIdParam, tableName, query, start, count, sortByFields) : ServiceHolder.getSecureAnalyticsDataService().search(userName, tableName, query, start, count, sortByFields);
                    searchResult = new ArrayList(searchResult);
                    resp.getOutputStream().write(GenericUtils.serializeObject(searchResult));
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else if (operation != null && operation.trim().equalsIgnoreCase("__search_count_opr")) {
                try {
                    int count = !securityEnabled ? ServiceHolder.getAnalyticsDataService().searchCount(tenantIdParam, tableName, query) : ServiceHolder.getSecureAnalyticsDataService().searchCount(userName, tableName, query);
                    PrintWriter output = resp.getWriter();
                    output.append("__searchCount").append(":").append(String.valueOf(count));
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else if (operation != null && operation.trim().equalsIgnoreCase("searchWithAggregates_opr")) {
                try {
                    Gson gson = new Gson();
                    String groupByField = req.getParameter("groupByField");
                    Type aggregateFieldsMapType = new TypeToken<List<AggregateField>>(){}.getType();
                    List fields = (List)gson.fromJson(req.getParameter("aggregatingFields"), aggregateFieldsMapType);
                    String parentPathAsString = req.getParameter("aggregateParentPath");
                    Type aggregateParentPath = new TypeToken<List<String>>(){}.getType();
                    List parentPath = (List)gson.fromJson(parentPathAsString, aggregateParentPath);
                    int aggregateLevel = Integer.parseInt(req.getParameter("aggregateLevel"));
                    int noOfRecords = Integer.parseInt(req.getParameter("noOfRecords"));
                    AggregateRequest aggregateRequest = new AggregateRequest();
                    aggregateRequest.setTableName(tableName);
                    aggregateRequest.setQuery(query);
                    aggregateRequest.setFields(fields);
                    aggregateRequest.setGroupByField(groupByField);
                    aggregateRequest.setAggregateLevel(aggregateLevel);
                    aggregateRequest.setParentPath(parentPath);
                    aggregateRequest.setNoOfRecords(noOfRecords);
                    AnalyticsIterator iterator = !securityEnabled ? ServiceHolder.getAnalyticsDataService().searchWithAggregates(tenantIdParam, aggregateRequest) : ServiceHolder.getSecureAnalyticsDataService().searchWithAggregates(userName, aggregateRequest);
                    while (iterator.hasNext()) {
                        Record record = (Record)iterator.next();
                        GenericUtils.serializeObject((Object)record, (OutputStream)resp.getOutputStream());
                    }
                    iterator.close();
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            int tenantIdParam = -1;
            if (!securityEnabled) {
                tenantIdParam = Integer.parseInt(req.getParameter("tenant_id"));
            }
            String userName = req.getParameter("username");
            if (operation != null && operation.trim().equalsIgnoreCase("__drillDownSearch_opr")) {
                this.doDrillDownSearch(req, resp, securityEnabled, tenantIdParam, userName);
            } else if (operation != null && operation.trim().equalsIgnoreCase("drillDownSearchCount_opr")) {
                this.doDrillDownSearchCount(req, resp, securityEnabled, tenantIdParam, userName);
            } else if (operation != null && operation.trim().equalsIgnoreCase("drillDownSearchCategory_opr")) {
                this.doDrillDownCategories(req, resp, securityEnabled, tenantIdParam, userName);
            } else if (operation != null && operation.trim().equalsIgnoreCase("drillDownRangeCount_opr")) {
                this.doDrillDownRangeCount(req, resp, securityEnabled, tenantIdParam, userName);
            } else if (operation != null && operation.trim().equalsIgnoreCase("searchMultiTablesWithAggregates_opr")) {
                this.doSearchMultiTablesWithAggregates(req, resp, securityEnabled, tenantIdParam, userName);
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }

    private void doDrillDownSearch(HttpServletRequest req, HttpServletResponse resp, boolean securityEnabled, int tenantIdParam, String userName) throws IOException {
        ServletInputStream servletInputStream = req.getInputStream();
        try {
            AnalyticsDrillDownRequest drillDownRequest = (AnalyticsDrillDownRequest)GenericUtils.deserializeObject((InputStream)servletInputStream);
            ArrayList drillDownResult = new ArrayList();
            if (!securityEnabled) {
                drillDownResult.addAll(ServiceHolder.getAnalyticsDataService().drillDownSearch(tenantIdParam, drillDownRequest));
            } else {
                drillDownResult.addAll(ServiceHolder.getSecureAnalyticsDataService().drillDownSearch(userName, drillDownRequest));
            }
            GenericUtils.serializeObject(drillDownResult, (OutputStream)resp.getOutputStream());
            resp.setStatus(200);
        }
        catch (AnalyticsException e) {
            resp.sendError(417, e.getMessage());
        }
    }

    private void doDrillDownSearchCount(HttpServletRequest req, HttpServletResponse resp, boolean securityEnabled, int tenantIdParam, String userName) throws IOException {
        ServletInputStream servletInputStream = req.getInputStream();
        try {
            AnalyticsDrillDownRequest drillDownRequest = (AnalyticsDrillDownRequest)GenericUtils.deserializeObject((InputStream)servletInputStream);
            double resultCount = !securityEnabled ? ServiceHolder.getAnalyticsDataService().drillDownSearchCount(tenantIdParam, drillDownRequest) : ServiceHolder.getSecureAnalyticsDataService().drillDownSearchCount(userName, drillDownRequest);
            GenericUtils.serializeObject((Object)resultCount, (OutputStream)resp.getOutputStream());
            resp.setStatus(200);
        }
        catch (AnalyticsException e) {
            resp.sendError(417, e.getMessage());
        }
    }

    private void doDrillDownCategories(HttpServletRequest req, HttpServletResponse resp, boolean securityEnabled, int tenantIdParam, String userName) throws IOException {
        ServletInputStream servletInputStream = req.getInputStream();
        try {
            CategoryDrillDownRequest drillDownRequest = (CategoryDrillDownRequest)GenericUtils.deserializeObject((InputStream)servletInputStream);
            SubCategories subCategories = !securityEnabled ? ServiceHolder.getAnalyticsDataService().drillDownCategories(tenantIdParam, drillDownRequest) : ServiceHolder.getSecureAnalyticsDataService().drillDownCategories(userName, drillDownRequest);
            GenericUtils.serializeObject((Object)subCategories, (OutputStream)resp.getOutputStream());
            resp.setStatus(200);
        }
        catch (AnalyticsException e) {
            resp.sendError(417, e.getMessage());
        }
    }

    private void doDrillDownRangeCount(HttpServletRequest req, HttpServletResponse resp, boolean securityEnabled, int tenantIdParam, String userName) throws IOException {
        ServletInputStream servletInputStream = req.getInputStream();
        try {
            AnalyticsDrillDownRequest drillDownRequest = (AnalyticsDrillDownRequest)GenericUtils.deserializeObject((InputStream)servletInputStream);
            List ranges = !securityEnabled ? ServiceHolder.getAnalyticsDataService().drillDownRangeCount(tenantIdParam, drillDownRequest) : ServiceHolder.getSecureAnalyticsDataService().drillDownRangeCount(userName, drillDownRequest);
            GenericUtils.serializeObject((Object)ranges, (OutputStream)resp.getOutputStream());
            resp.setStatus(200);
        }
        catch (AnalyticsException e) {
            resp.sendError(417, e.getMessage());
        }
    }

    private void doSearchMultiTablesWithAggregates(HttpServletRequest req, HttpServletResponse resp, boolean securityEnabled, int tenantIdParam, String userName) throws IOException {
        ServletInputStream servletInputStream = req.getInputStream();
        try {
            AggregateRequest[] requests = (AggregateRequest[])GenericUtils.deserializeObject((InputStream)servletInputStream);
            List iterators = !securityEnabled ? ServiceHolder.getAnalyticsDataService().searchWithAggregates(tenantIdParam, requests) : ServiceHolder.getSecureAnalyticsDataService().searchWithAggregates(userName, requests);
            ArrayList<List> aggregatedRecords = new ArrayList<List>();
            for (AnalyticsIterator iterator : iterators) {
                aggregatedRecords.add(IteratorUtils.toList((Iterator)iterator));
            }
            GenericUtils.serializeObject(aggregatedRecords, (OutputStream)resp.getOutputStream());
            resp.setStatus(200);
        }
        catch (AnalyticsException e) {
            resp.sendError(417, e.getMessage());
        }
    }
}

