/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;

public class AnalyticsRecordStoreProcessor
extends HttpServlet {
    private static final long serialVersionUID = 5655324228428424513L;
    private static final Log log = LogFactory.getLog(AnalyticsRecordStoreProcessor.class);

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            if (operation != null && operation.trim().equalsIgnoreCase("__get_record_store_opr")) {
                String tableName = req.getParameter("table_name");
                if (!securityEnabled) {
                    int tenantId = Integer.parseInt(req.getParameter("tenant_id"));
                    try {
                        String recordStore = ServiceHolder.getAnalyticsDataService().getRecordStoreNameByTable(tenantId, tableName);
                        resp.setStatus(200);
                        PrintWriter responseWriter = resp.getWriter();
                        responseWriter.print("__recordStoreName:" + recordStore);
                    }
                    catch (AnalyticsException e) {
                        resp.sendError(500, e.getMessage());
                    }
                } else {
                    String username = req.getParameter("username");
                    try {
                        String recordStore = ServiceHolder.getSecureAnalyticsDataService().getRecordStoreNameByTable(username, tableName);
                        resp.setStatus(200);
                        PrintWriter responseWriter = resp.getWriter();
                        responseWriter.print("__recordStoreName:" + recordStore);
                    }
                    catch (AnalyticsException e) {
                        resp.sendError(500, e.getMessage());
                    }
                }
            } else if (operation != null && operation.trim().equalsIgnoreCase("__list_record_stores_opr")) {
                List recordStores = ServiceHolder.getAnalyticsDataService().listRecordStoreNames();
                GenericUtils.serializeObject((Object)recordStores, (OutputStream)resp.getOutputStream());
                resp.setStatus(200);
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }
}

