/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDataResponse;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsIterator;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.RecordGroup;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.io.commons.RemoteRecordGroup;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;

public class AnalyticsRecordReadProcessor
extends HttpServlet {
    private static final long serialVersionUID = -3656252576106717848L;
    private static final Log log = LogFactory.getLog(AnalyticsRecordReadProcessor.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            if (operation != null && operation.trim().equalsIgnoreCase("__get_range_record_group_opr")) {
                this.doGetRangeRecordGroupOperation(securityEnabled, req, resp);
            } else if (operation != null && operation.trim().equalsIgnoreCase("__get_ids_record_group_opr")) {
                this.doIdsRecordGroup(securityEnabled, req, resp);
            } else if (operation != null && operation.trim().equalsIgnoreCase("__get_records_with_key_values_opr")) {
                this.doGetRecordWithKeyValues(securityEnabled, req, resp);
            } else if (operation != null && operation.trim().equalsIgnoreCase("__readRecord_opr")) {
                this.doReadRecords(req, resp);
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with post request!"));
            }
        }
    }

    private void doGetRangeRecordGroupOperation(boolean securityEnabled, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int tenantId = -1;
        Gson gson = new Gson();
        if (!securityEnabled) {
            tenantId = Integer.parseInt(req.getParameter("tenant_id"));
        }
        String userName = req.getParameter("username");
        String tableName = req.getParameter("table_name");
        int partitionHint = Integer.parseInt(req.getParameter("partitionerNo"));
        Type columnsList = new TypeToken<List<String>>(){}.getType();
        List list = (List)gson.fromJson(req.getParameter("columns"), columnsList);
        long timeFrom = Long.parseLong(req.getParameter("timeFrom"));
        long timeTo = Long.parseLong(req.getParameter("timeTo"));
        int recordFrom = Integer.parseInt(req.getParameter("recordFrom"));
        int recordsCount = Integer.parseInt(req.getParameter("count"));
        try {
            AnalyticsDataResponse analyticsDataResponse = !securityEnabled ? ServiceHolder.getAnalyticsDataService().get(tenantId, tableName, partitionHint, list, timeFrom, timeTo, recordFrom, recordsCount) : ServiceHolder.getSecureAnalyticsDataService().get(userName, tableName, partitionHint, list, timeFrom, timeTo, recordFrom, recordsCount);
            resp.setStatus(200);
            GenericUtils.serializeObject((Object)this.localToRemoteAnalyticsDataResponse(analyticsDataResponse), (OutputStream)resp.getOutputStream());
        }
        catch (AnalyticsException e) {
            resp.sendError(500, e.getMessage());
        }
    }

    private RecordGroup localToRemoteRecordGroup(RecordGroup rg) throws AnalyticsException {
        RemoteRecordGroup result = new RemoteRecordGroup();
        result.setBinaryRecordGroup(GenericUtils.serializeObject((Object)rg));
        result.setLocations(rg.getLocations());
        return result;
    }

    private AnalyticsDataResponse localToRemoteAnalyticsDataResponse(AnalyticsDataResponse resp) throws AnalyticsException {
        List localEntries = resp.getEntries();
        ArrayList<AnalyticsDataResponse.Entry> remoteEntries = new ArrayList<AnalyticsDataResponse.Entry>(localEntries.size());
        for (AnalyticsDataResponse.Entry entry : localEntries) {
            remoteEntries.add(new AnalyticsDataResponse.Entry(entry.getRecordStoreName(), this.localToRemoteRecordGroup(entry.getRecordGroup())));
        }
        return new AnalyticsDataResponse(remoteEntries);
    }

    private void doIdsRecordGroup(boolean securityEnabled, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int tenantId = -1;
        Gson gson = new Gson();
        if (!securityEnabled) {
            tenantId = Integer.parseInt(req.getParameter("tenant_id"));
        }
        String userName = req.getParameter("username");
        String tableName = req.getParameter("table_name");
        int partitionHint = Integer.parseInt(req.getParameter("partitionerNo"));
        Type columnsList = new TypeToken<List<String>>(){}.getType();
        List columns = (List)gson.fromJson(req.getParameter("columns"), columnsList);
        List ids = (List)gson.fromJson(req.getParameter("recordIds"), columnsList);
        try {
            AnalyticsDataResponse analyticsDataResponse = !securityEnabled ? ServiceHolder.getAnalyticsDataService().get(tenantId, tableName, partitionHint, columns, ids) : ServiceHolder.getSecureAnalyticsDataService().get(userName, tableName, partitionHint, columns, ids);
            resp.setStatus(200);
            GenericUtils.serializeObject((Object)this.localToRemoteAnalyticsDataResponse(analyticsDataResponse), (OutputStream)resp.getOutputStream());
        }
        catch (AnalyticsException e) {
            resp.sendError(500, e.getMessage());
        }
    }

    private void doGetRecordWithKeyValues(boolean securityEnabled, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int tenantId = -1;
        Gson gson = new Gson();
        if (!securityEnabled) {
            tenantId = Integer.parseInt(req.getParameter("tenant_id"));
        }
        String userName = req.getParameter("username");
        String tableName = req.getParameter("table_name");
        int partitionHint = Integer.parseInt(req.getParameter("partitionerNo"));
        Type columnsList = new TypeToken<List<String>>(){}.getType();
        Type keyValueList = new TypeToken<List<Map<String, Object>>>(){}.getType();
        List columns = (List)gson.fromJson(req.getParameter("columns"), columnsList);
        List valuesBatch = (List)gson.fromJson(req.getParameter("keyValues"), keyValueList);
        try {
            AnalyticsDataResponse analyticsDataResponse = !securityEnabled ? ServiceHolder.getAnalyticsDataService().getWithKeyValues(tenantId, tableName, partitionHint, columns, valuesBatch) : ServiceHolder.getSecureAnalyticsDataService().getWithKeyValues(userName, tableName, partitionHint, columns, valuesBatch);
            resp.setStatus(200);
            GenericUtils.serializeObject((Object)this.localToRemoteAnalyticsDataResponse(analyticsDataResponse), (OutputStream)resp.getOutputStream());
        }
        catch (AnalyticsException e) {
            resp.sendError(500, e.getMessage());
        }
    }

    private void doReadRecords(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String recordStoreName = req.getParameter("record_store_name");
        ServletInputStream servletInputStream = req.getInputStream();
        try {
            RemoteRecordGroup remoteRecordGroupObj = (RemoteRecordGroup)GenericUtils.deserializeObject((InputStream)servletInputStream);
            AnalyticsIterator records = ServiceHolder.getAnalyticsDataService().readRecords(recordStoreName, remoteRecordGroupObj.getRecordGroupFromBinary());
            while (records.hasNext()) {
                Record record = (Record)records.next();
                GenericUtils.serializeObject((Object)record, (OutputStream)resp.getOutputStream());
            }
            records.close();
            resp.setStatus(200);
        }
        catch (AnalyticsException e) {
            resp.sendError(500, e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            if (operation != null && operation.trim().equalsIgnoreCase("__readRecord_opr")) {
                this.doReadRecords(req, resp);
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }
}

