/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;

public class AnalyticsRecordProcessor
extends HttpServlet {
    private static final long serialVersionUID = -6519267839269075681L;
    private static final Log log = LogFactory.getLog(AnalyticsRecordProcessor.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            if (operation != null && operation.trim().equalsIgnoreCase("__get_record_count_opr")) {
                int tenantIdParam = -1;
                if (!securityEnabled) {
                    tenantIdParam = Integer.parseInt(req.getParameter("tenant_id"));
                }
                String userName = req.getParameter("username");
                String tableName = req.getParameter("table_name");
                long timeFrom = Long.parseLong(req.getParameter("timeFrom"));
                long timeTo = Long.parseLong(req.getParameter("timeTo"));
                try {
                    long recordCount = !securityEnabled ? ServiceHolder.getAnalyticsDataService().getRecordCount(tenantIdParam, tableName, timeFrom, timeTo) : ServiceHolder.getSecureAnalyticsDataService().getRecordCount(userName, tableName, timeFrom, timeTo);
                    PrintWriter outputWriter = resp.getWriter();
                    outputWriter.append("__recordCount").append(":").append(String.valueOf(recordCount));
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            if (operation != null && operation.trim().equalsIgnoreCase("__put_records_opr")) {
                String username = req.getParameter("username");
                try {
                    List records = (List)GenericUtils.deserializeObject((InputStream)req.getInputStream());
                    if (!securityEnabled) {
                        ServiceHolder.getAnalyticsDataService().put(records);
                    } else {
                        ServiceHolder.getSecureAnalyticsDataService().put(username, records);
                    }
                    ArrayList<String> recordIds = new ArrayList<String>();
                    for (Record record : records) {
                        recordIds.add(record.getId());
                    }
                    resp.getOutputStream().write(GenericUtils.serializeObject(recordIds));
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            int tenantIdParam = -1;
            if (!securityEnabled) {
                tenantIdParam = Integer.parseInt(req.getParameter("tenant_id"));
            }
            String userName = req.getParameter("username");
            String tableName = req.getParameter("table_name");
            if (operation != null && operation.trim().equalsIgnoreCase("__delete_records_range_opr")) {
                long timeFrom = Long.parseLong(req.getParameter("timeFrom"));
                long timeTo = Long.parseLong(req.getParameter("timeTo"));
                try {
                    if (!securityEnabled) {
                        ServiceHolder.getAnalyticsDataService().delete(tenantIdParam, tableName, timeFrom, timeTo);
                    } else {
                        ServiceHolder.getSecureAnalyticsDataService().delete(userName, tableName, timeFrom, timeTo);
                    }
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else if (operation != null && operation.trim().equalsIgnoreCase("__delete_records_ids_opr")) {
                String jsonRecordIds = req.getParameter("recordIds");
                Type recordIdListType = new TypeToken<List<String>>(){}.getType();
                List recordIds = (List)new Gson().fromJson(jsonRecordIds, recordIdListType);
                try {
                    if (!securityEnabled) {
                        ServiceHolder.getAnalyticsDataService().delete(tenantIdParam, tableName, recordIds);
                    } else {
                        ServiceHolder.getSecureAnalyticsDataService().delete(userName, tableName, recordIds);
                    }
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with post request!"));
            }
        }
    }
}

