/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;

public class AnalyticsManagementProcessor
extends HttpServlet {
    private static final long serialVersionUID = 1239990860409556231L;
    private static final Log log = LogFactory.getLog(AnalyticsManagementProcessor.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String operation = req.getParameter("__operation");
        if (operation != null && operation.equalsIgnoreCase("__login_opr")) {
            String[] credentials = this.getUserPassword(req.getHeader("Authorization"));
            if (credentials == null) {
                resp.sendError(401, "Invalid authentication!");
            } else {
                String userName = credentials[0];
                String password = credentials[1];
                try {
                    String sessionId = ServiceHolder.getAuthenticator().authenticate(userName, password);
                    PrintWriter writer = resp.getWriter();
                    writer.print("__sessionId:" + sessionId);
                    resp.setStatus(200);
                }
                catch (AnalyticsAPIAuthenticationException e) {
                    resp.sendError(401, "Unauthorized user: " + userName);
                }
            }
        } else if (operation != null && operation.equalsIgnoreCase("__is_pagination_supported_opr")) {
            String sessionId = req.getHeader("__sessionId");
            if (sessionId == null || sessionId.trim().isEmpty()) {
                resp.sendError(401, "No session id found, Please login first!");
            } else {
                try {
                    ServiceHolder.getAuthenticator().validateSessionId(sessionId);
                }
                catch (AnalyticsAPIAuthenticationException e) {
                    resp.sendError(401, "No session id found, Please login first!");
                }
            }
            String recordStoreName = req.getParameter("record_store_name");
            try {
                boolean isSupported = ServiceHolder.getAnalyticsDataService().isPaginationSupported(recordStoreName);
                PrintWriter writer = resp.getWriter();
                writer.print("__paginationSupport:" + isSupported);
                resp.setStatus(200);
            }
            catch (AnalyticsException e) {
                resp.sendError(500, e.getMessage());
            }
        } else if (operation != null && operation.equalsIgnoreCase("__is_record_count_supported_opr")) {
            String sessionId = req.getHeader("__sessionId");
            if (sessionId == null || sessionId.trim().isEmpty()) {
                resp.sendError(401, "No session id found, Please login first!");
            } else {
                try {
                    ServiceHolder.getAuthenticator().validateSessionId(sessionId);
                }
                catch (AnalyticsAPIAuthenticationException e) {
                    resp.sendError(401, "No session id found, Please login first!");
                }
            }
            String recordStoreName = req.getParameter("record_store_name");
            try {
                boolean isSupported = ServiceHolder.getAnalyticsDataService().isRecordCountSupported(recordStoreName);
                PrintWriter writer = resp.getWriter();
                writer.print("__recordCountSupport:" + isSupported);
                resp.setStatus(200);
            }
            catch (AnalyticsException e) {
                resp.sendError(500, e.getMessage());
            }
        } else {
            resp.sendError(406, "Unavailable operation provided!");
            log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
        }
    }

    private String[] getUserPassword(String authHeader) {
        if (authHeader == null) {
            return null;
        }
        if (!authHeader.startsWith("Basic ")) {
            return null;
        }
        String[] userPassword = new String(Base64.decode((String)authHeader.substring(6)), StandardCharsets.UTF_8).split(":");
        if (userPassword.length != 2) {
            return null;
        }
        return userPassword;
    }
}

