/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.servlet.exception.AnalyticsAPIAuthenticationException;
import org.wso2.carbon.analytics.servlet.internal.ServiceHolder;

public class AnalyticsIndexProcessor
extends HttpServlet {
    private static final long serialVersionUID = -4554701429299921629L;
    private static Log log = LogFactory.getLog(AnalyticsIndexProcessor.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            if (operation != null && operation.trim().equalsIgnoreCase("__wait_for_index_opr")) {
                long maxWait = Integer.parseInt(req.getParameter("maxWait"));
                String tableName = req.getParameter("table_name");
                if (tableName != null && !tableName.trim().isEmpty()) {
                    int tenantId = Integer.parseInt(req.getParameter("tenant_id"));
                    boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
                    String username = req.getParameter("username");
                    try {
                        if (!securityEnabled) {
                            ServiceHolder.getAnalyticsDataService().waitForIndexing(tenantId, tableName, maxWait);
                        } else {
                            ServiceHolder.getSecureAnalyticsDataService().waitForIndexing(username, tableName, maxWait);
                        }
                        resp.setStatus(200);
                    }
                    catch (AnalyticsException e) {
                        resp.sendError(417, e.getMessage());
                    }
                } else {
                    try {
                        ServiceHolder.getAnalyticsDataService().waitForIndexing(maxWait);
                        resp.setStatus(200);
                    }
                    catch (AnalyticsException e) {
                        resp.sendError(417, e.getMessage());
                    }
                }
            } else {
                resp.sendError(406, "unsupported operation performed with post request!");
                log.error((Object)("unsupported operation performed : " + operation + " with post request!"));
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            int tenantId = -1;
            if (!securityEnabled) {
                tenantId = Integer.parseInt(req.getParameter("tenant_id"));
            }
            String userName = req.getParameter("username");
            if (operation != null && operation.trim().equalsIgnoreCase("__delete_indices_opr")) {
                String tableName = req.getParameter("table_name");
                try {
                    if (!securityEnabled) {
                        ServiceHolder.getAnalyticsDataService().clearIndexData(tenantId, tableName);
                    } else {
                        ServiceHolder.getSecureAnalyticsDataService().clearIndexData(userName, tableName);
                    }
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with delete request!");
                log.error((Object)("unsupported operation performed : " + operation + " with delete request!"));
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sessionId = req.getHeader("__sessionId");
        if (sessionId == null || sessionId.trim().isEmpty()) {
            resp.sendError(401, "No session id found, Please login first!");
        } else {
            try {
                ServiceHolder.getAuthenticator().validateSessionId(sessionId);
            }
            catch (AnalyticsAPIAuthenticationException e) {
                resp.sendError(401, "No session id found, Please login first!");
            }
            String operation = req.getParameter("__operation");
            boolean securityEnabled = Boolean.parseBoolean(req.getParameter("enableSecurity"));
            if (operation != null && operation.trim().equalsIgnoreCase("reIndex_opr")) {
                int tenantIdParam = -1;
                if (!securityEnabled) {
                    tenantIdParam = Integer.parseInt(req.getParameter("tenant_id"));
                }
                String userName = req.getParameter("username");
                String tableName = req.getParameter("table_name");
                long timeFrom = Long.parseLong(req.getParameter("timeFrom"));
                long timeTo = Long.parseLong(req.getParameter("timeTo"));
                try {
                    if (!securityEnabled) {
                        ServiceHolder.getAnalyticsDataService().reIndex(tenantIdParam, tableName, timeFrom, timeTo);
                    } else {
                        ServiceHolder.getSecureAnalyticsDataService().reIndex(userName, tableName, timeFrom, timeTo);
                    }
                    resp.setStatus(200);
                }
                catch (AnalyticsException e) {
                    resp.sendError(417, e.getMessage());
                }
            } else {
                resp.sendError(406, "unsupported operation performed with get request!");
                log.error((Object)("unsupported operation performed : " + operation + " with get request!"));
            }
        }
    }
}

