/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink.internal.queue;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.eventsink.internal.queue.AnalyticsEventQueueWorker;
import org.wso2.carbon.analytics.eventsink.internal.queue.WrappedEventFactory;
import org.wso2.carbon.analytics.eventsink.internal.util.ServiceHolder;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;

public class AnalyticsEventQueue {
    private static final Log log = LogFactory.getLog(AnalyticsEventQueue.class);
    private RingBuffer<WrappedEventFactory.WrappedEvent> ringBuffer;
    private AtomicInteger currentSize;
    private int currentEventSize;
    private int maxSize;
    private Semaphore semaphore;
    private final Object lock = new Object();

    public AnalyticsEventQueue(int tenantId) {
        Disruptor eventQueue = new Disruptor((EventFactory)new WrappedEventFactory(), ServiceHolder.getAnalyticsEventSinkConfiguration().getQueueSize(), (Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Thread pool- component - AnalyticsEventQueue").build()));
        eventQueue.handleEventsWith(new EventHandler[]{new AnalyticsEventQueueWorker(tenantId, this)});
        this.currentEventSize = 0;
        this.ringBuffer = eventQueue.start();
        this.currentSize = new AtomicInteger(0);
        this.maxSize = ServiceHolder.getAnalyticsEventSinkConfiguration().getMaxQueueCapacity();
        this.semaphore = new Semaphore(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event Queue Size = " + ServiceHolder.getAnalyticsEventSinkConfiguration().getQueueSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(Event event) {
        block11: {
            this.currentEventSize = DataBridgeCommonsUtils.getSize((Event)event) + 4;
            if (this.currentSize.get() >= this.maxSize) {
                try {
                    this.semaphore.acquire();
                    if (this.semaphore.availablePermits() != 0) break block11;
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.semaphore.availablePermits() == 0) {
                            this.semaphore.release();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        long sequence = this.ringBuffer.next();
        WrappedEventFactory.WrappedEvent bufferedEvent = (WrappedEventFactory.WrappedEvent)this.ringBuffer.get(sequence);
        bufferedEvent.setEvent(event);
        bufferedEvent.setSize(this.currentEventSize);
        this.ringBuffer.publish(sequence);
        if (this.currentSize.addAndGet(this.currentEventSize) >= this.maxSize) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("current queue size in bytes : " + this.currentSize + ", remaining capacity : " + this.ringBuffer.remainingCapacity()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReleasedEvent(WrappedEventFactory.WrappedEvent wrappedEvent, boolean endOfBatch) {
        this.currentSize.addAndGet(-wrappedEvent.getSize());
        wrappedEvent.setEvent(null);
        if (this.semaphore.availablePermits() == 0 && this.currentEventSize + this.currentSize.get() < this.maxSize || endOfBatch) {
            Object object = this.lock;
            synchronized (object) {
                if (this.semaphore.availablePermits() == 0 && this.currentEventSize + this.currentSize.get() < this.maxSize || endOfBatch) {
                    this.semaphore.release();
                }
            }
        }
    }

    public int getRemainingQueueSize() {
        return (int)this.ringBuffer.remainingCapacity();
    }

    public long getRemainingBufferCapacity() {
        return this.maxSize - this.currentSize.get();
    }
}

