/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.wso2.carbon.analytics.eventsink.AnalyticsTableSchema;
import org.wso2.carbon.analytics.eventsink.exception.AnalyticsEventStoreException;

@XmlRootElement(name="EventStoreConfiguration")
public class AnalyticsEventStore {
    private String name;
    private String recordStore;
    private EventSource eventSource;
    private boolean mergeSchema;
    private AnalyticsTableSchema analyticsTableSchema;

    @XmlElement(name="Source")
    public EventSource getEventSource() {
        return this.eventSource;
    }

    @XmlElement(name="RecordStoreName")
    public String getRecordStore() {
        return this.recordStore;
    }

    public void setRecordStore(String recordStore) {
        this.recordStore = recordStore;
    }

    public void setEventSource(EventSource eventSource) throws AnalyticsEventStoreException {
        String name;
        if (eventSource.getStreamIds().size() > 0) {
            name = this.generateName(eventSource.getStreamIds().get(0));
            for (String streamId : eventSource.getStreamIds()) {
                if (name.equals(this.generateName(streamId))) continue;
                throw new AnalyticsEventStoreException("Only the streams that can be inserted into same table can be accepted! Expected table name : " + name + ", but stream id : " + streamId + " is not valid.");
            }
        } else {
            throw new AnalyticsEventStoreException("Event source should contain atleast one stream, but it's empty!");
        }
        this.eventSource = eventSource;
        this.name = name;
    }

    @XmlElement(name="TableSchema")
    public AnalyticsTableSchema getAnalyticsTableSchema() {
        return this.analyticsTableSchema;
    }

    public void setAnalyticsTableSchema(AnalyticsTableSchema analyticsTableSchema) {
        this.analyticsTableSchema = analyticsTableSchema;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof AnalyticsEventStore) {
            AnalyticsEventStore analyticsEventStore = (AnalyticsEventStore)object;
            return analyticsEventStore.getName().equalsIgnoreCase(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private String generateName(String streamId) {
        String streamName = streamId.split(":")[0].trim();
        String tableName = "";
        if (!streamName.isEmpty()) {
            tableName = streamName.replace('.', '_');
        }
        return tableName;
    }

    @XmlElement(name="MergeSchema")
    public boolean isMergeSchema() {
        return this.mergeSchema;
    }

    public void setMergeSchema(boolean isMergeSchema) {
        this.mergeSchema = isMergeSchema;
    }

    public static class EventSource {
        private List<String> streamIds;

        @XmlElement(name="StreamId")
        public List<String> getStreamIds() {
            return this.streamIds;
        }

        public void setStreamIds(List<String> streamIds) {
            this.streamIds = streamIds;
        }

        public boolean contains(String streamId) {
            return this.streamIds != null && this.streamIds.contains(streamId);
        }
    }
}

