/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.wso2.carbon.analytics.api.AnalyticsDataAPI;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDataResponse;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;

public class AnalyticsDataAPIUtil {
    public static List<Record> listRecords(AnalyticsDataAPI ads, AnalyticsDataResponse response) throws AnalyticsException {
        ArrayList<Record> result = new ArrayList<Record>();
        for (AnalyticsDataResponse.Entry entry : response.getEntries()) {
            result.addAll(IteratorUtils.toList(ads.readRecords(entry.getRecordStoreName(), entry.getRecordGroup())));
        }
        return result;
    }

    public static Iterator<Record> responseToIterator(AnalyticsDataAPI service, AnalyticsDataResponse response) throws AnalyticsException {
        return new ResponseIterator(service, response);
    }

    public static class ResponseIterator
    implements Iterator<Record> {
        private AnalyticsDataResponse.Entry[] entries;
        private Iterator<Record> itr;
        private AnalyticsDataAPI service;
        private int index = -1;

        public ResponseIterator(AnalyticsDataAPI service, AnalyticsDataResponse response) throws AnalyticsException {
            this.service = service;
            this.entries = response.getEntries().toArray(new AnalyticsDataResponse.Entry[0]);
        }

        @Override
        public boolean hasNext() {
            boolean result = this.itr == null ? false : this.itr.hasNext();
            if (result) {
                return true;
            }
            if (this.entries.length > this.index + 1) {
                try {
                    ++this.index;
                    this.itr = this.service.readRecords(this.entries[this.index].getRecordStoreName(), this.entries[this.index].getRecordGroup());
                }
                catch (AnalyticsException e) {
                    throw new IllegalStateException("Error in traversing record group: " + e.getMessage(), e);
                }
                return this.hasNext();
            }
            return false;
        }

        @Override
        public Record next() {
            if (this.hasNext()) {
                return this.itr.next();
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

