/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.api.internal.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.wso2.carbon.analytics.api.RemoteRecordIterator;
import org.wso2.carbon.analytics.api.exception.AnalyticsServiceAuthenticationException;
import org.wso2.carbon.analytics.api.exception.AnalyticsServiceException;
import org.wso2.carbon.analytics.api.exception.AnalyticsServiceRemoteException;
import org.wso2.carbon.analytics.api.exception.AnalyticsServiceUnauthorizedException;
import org.wso2.carbon.analytics.api.internal.AnalyticsDataConfiguration;
import org.wso2.carbon.analytics.dataservice.commons.AggregateRequest;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDataResponse;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDrillDownRange;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDrillDownRequest;
import org.wso2.carbon.analytics.dataservice.commons.CategoryDrillDownRequest;
import org.wso2.carbon.analytics.dataservice.commons.SearchResultEntry;
import org.wso2.carbon.analytics.dataservice.commons.SortByField;
import org.wso2.carbon.analytics.dataservice.commons.SubCategories;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsIterator;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.RecordGroup;
import org.wso2.carbon.analytics.io.commons.GenericUtils;
import org.wso2.carbon.base.ServerConfiguration;

public class AnalyticsAPIHttpClient {
    private static final Log log = LogFactory.getLog(AnalyticsAPIHttpClient.class);
    private static AnalyticsAPIHttpClient instance;
    private String hostname;
    private int port;
    private String protocol;
    private String sessionId;
    private DefaultHttpClient httpClient;
    private Gson gson;

    private AnalyticsAPIHttpClient(String protocol, String hostname, int port, int maxPerRoute, int maxConnection, int socketTimeout, int connectionTimeout, String trustStoreLocation, String trustStorePassword) {
        this.hostname = hostname;
        this.port = port;
        this.protocol = protocol;
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        if (this.protocol.equalsIgnoreCase("http")) {
            schemeRegistry.register(new Scheme(this.protocol, port, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        } else {
            System.setProperty("javax.net.ssl.trustStore", trustStoreLocation);
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
            schemeRegistry.register(new Scheme(this.protocol, port, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        }
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(schemeRegistry);
        connectionManager.setDefaultMaxPerRoute(maxPerRoute);
        connectionManager.setMaxTotal(maxConnection);
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.socket.timeout", (Object)socketTimeout);
        params.setParameter("http.connection.timeout", (Object)connectionTimeout);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)params);
        this.gson = new GsonBuilder().create();
    }

    public static void init(AnalyticsDataConfiguration dataConfiguration) throws AnalyticsServiceException {
        try {
            URL url = new URL(dataConfiguration.getEndpoint());
            instance = new AnalyticsAPIHttpClient(url.getProtocol(), url.getHost(), url.getPort(), dataConfiguration.getMaxConnectionsPerRoute(), dataConfiguration.getMaxConnections(), dataConfiguration.getSocketConnectionTimeoutMS(), dataConfiguration.getConnectionTimeoutMS(), AnalyticsAPIHttpClient.getTrustStoreLocation(dataConfiguration.getTrustStoreLocation()), AnalyticsAPIHttpClient.getTrustStorePassword(dataConfiguration.getTrustStorePassword()));
        }
        catch (MalformedURLException e) {
            throw new AnalyticsServiceException("Error while initializing the analytics http client. " + e.getMessage(), e);
        }
    }

    private static String getTrustStoreLocation(String trustStoreLocation) {
        if (trustStoreLocation == null || trustStoreLocation.trim().isEmpty()) {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            String trustStore = serverConfig.getFirstProperty("Security.TrustStore.Location");
            if (trustStore == null) {
                trustStore = System.getProperty("Security.TrustStore.Location");
            }
            return trustStore;
        }
        return new File(trustStoreLocation).getAbsolutePath();
    }

    private static String getTrustStorePassword(String trustStorePassword) {
        if (trustStorePassword == null || trustStorePassword.trim().isEmpty()) {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            String trustStorePw = serverConfig.getFirstProperty("Security.TrustStore.Password");
            if (trustStorePw == null) {
                trustStorePw = System.getProperty("Security.TrustStore.Password");
            }
            return trustStorePw;
        }
        return trustStorePassword;
    }

    public static AnalyticsAPIHttpClient getInstance() {
        return instance;
    }

    public synchronized void authenticate(String username, String password) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsManagementProcessor").setParameter("__operation", "__login_opr");
        try {
            String[] reponseElements;
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("Authorization", "Basic " + Base64.encode((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8)));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = httpResponse.getStatusLine().toString();
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                if (httpResponse.getStatusLine().getStatusCode() != 404) {
                    throw new AnalyticsServiceAuthenticationException("Authentication failed for user : " + username + " ." + "Response received from remote instance : " + response);
                }
                throw new AnalyticsServiceRemoteException("Unable to reach the endpoint : " + builder.build().toString() + ". " + response);
            }
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (response.startsWith("__sessionId")) {
                reponseElements = response.split(":");
                if (reponseElements.length != 2) {
                    throw new AnalyticsServiceAuthenticationException("Invalid response returned, cannot find sessionId. Response:" + response);
                }
            } else {
                throw new AnalyticsServiceAuthenticationException("Invalid response returned, no session id found!" + response);
            }
            this.sessionId = reponseElements[1];
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided for authentication. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceRemoteException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public void validateAndAuthenticate(String username, String password) throws AnalyticsServiceException {
        if (this.sessionId == null) {
            int numberOfRetry = 0;
            while (numberOfRetry < 5) {
                try {
                    ++numberOfRetry;
                    this.authenticate(username, password);
                    return;
                }
                catch (AnalyticsServiceRemoteException ex) {
                    if (numberOfRetry == 4) {
                        log.error((Object)"Unable to connect to remote service, have retried 5 times, but unable to reach. ", (Throwable)ex);
                        continue;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private String getResponseString(HttpResponse httpResponse) throws AnalyticsServiceException {
        BufferedReader br = null;
        try {
            String readLine;
            br = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent(), StandardCharsets.UTF_8));
            StringBuffer response = new StringBuffer();
            while ((readLine = br.readLine()) != null) {
                response.append(readLine);
            }
            String string = response.toString();
            return string;
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while reading the response from the remote service. " + e.getMessage(), e);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error while closing the connection! " + e.getMessage()));
                }
            }
        }
    }

    public synchronized void invalidateSessionAndAuthenticate(String userName, String password) {
        this.sessionId = null;
        this.validateAndAuthenticate(userName, password);
    }

    public void createTable(int tenantId, String username, String recordStoreName, String tableName, boolean securityEnabled, boolean ifNotExists) throws AnalyticsServiceException, AnalyticsServiceUnauthorizedException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsTableProcessor");
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (ifNotExists) {
                params.add(new BasicNameValuePair("__operation", "__create_if_not_exists_table_opr"));
            } else {
                params.add(new BasicNameValuePair("__operation", "__create_table_opr"));
            }
            if (!securityEnabled) {
                params.add(new BasicNameValuePair("tenant_id", String.valueOf(tenantId)));
            } else {
                params.add(new BasicNameValuePair("username", username));
            }
            if (recordStoreName != null) {
                params.add(new BasicNameValuePair("record_store_name", recordStoreName));
            }
            params.add(new BasicNameValuePair("enableSecurity", String.valueOf(securityEnabled)));
            params.add(new BasicNameValuePair("table_name", tableName));
            postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to create the table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to create the table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public void setTableSchema(int tenantId, String username, String tableName, AnalyticsSchema schema, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsTableSchemaProcessor").addParameter("__operation", "__set_schema_opr").addParameter("enableSecurity", String.valueOf(securityEnabled)).addParameter("tenant_id", String.valueOf(tenantId)).addParameter("table_name", tableName);
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            postMethod.setEntity((HttpEntity)new ByteArrayEntity(GenericUtils.serializeObject((Object)schema)));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to set the schema for the table - " + tableName + ", schema - " + this.gson.toJson((Object)schema) + " for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to set the schema for the table - " + tableName + ", schema - " + this.gson.toJson((Object)schema) + " for tenant id : " + tenantId + ". " + response);
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public AnalyticsSchema getTableSchema(int tenantId, String username, String tableName, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsTableSchemaProcessor").addParameter("__operation", "__get_schema_opr").addParameter("table_name", tableName).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to get the schema for the table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to get the schema for the table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            Object analyticsSchemaObject = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (analyticsSchemaObject != null && analyticsSchemaObject instanceof AnalyticsSchema) {
                return (AnalyticsSchema)analyticsSchemaObject;
            }
            throw new AnalyticsServiceException(this.getUnexpectedResponseReturnedErrorMsg("getting the table schema", tableName, "analytics schema object ", analyticsSchemaObject));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public boolean isTableExists(int tenantId, String username, String tableName, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsTableProcessor").addParameter("__operation", "__table_exists_opr").addParameter("table_name", tableName).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Unable to check the existence for the table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Unable to check the existence for the table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            if (response.startsWith("__tableExists")) {
                String[] reponseElements = response.split(":");
                if (reponseElements.length == 2) {
                    return Boolean.parseBoolean(reponseElements[1]);
                }
                throw new AnalyticsServiceException("Invalid response returned, cannot find table existence message. Response:" + response);
            }
            throw new AnalyticsServiceException("Invalid response returned, table existence message not found!" + response);
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public List<String> listTables(int tenantId, String username, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsTableProcessor").addParameter("__operation", "__list_tables_opr").addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to get the list of tables for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to get the list of tables for tenant id : " + tenantId + ". " + response);
            }
            Object listOfTablesObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (listOfTablesObj != null && listOfTablesObj instanceof List) {
                return (List)listOfTablesObj;
            }
            throw new AnalyticsServiceException(this.getUnexpectedResponseReturnedErrorMsg("getting list of tables", null, "list of tables", listOfTablesObj));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public void deleteTable(int tenantId, String username, String tableName, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsTableProcessor").addParameter("__operation", "__delete_table_opr").addParameter("table_name", tableName).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpDelete deleteMethod = new HttpDelete(builder.build().toString());
            deleteMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)deleteMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to delete the table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to delete the table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public long getRecordCount(int tenantId, String username, String tableName, long timeFrom, long timeTo, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordProcessor").addParameter("__operation", "__get_record_count_opr").addParameter("table_name", tableName).addParameter("timeFrom", String.valueOf(timeFrom)).addParameter("timeTo", String.valueOf(timeTo)).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Unable to get the record count for the table - " + tableName + ", time from : " + timeFrom + " , timeTo : " + timeTo + " for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Unable to get the record count for the table - " + tableName + ", time from : " + timeFrom + " , timeTo : " + timeTo + " for tenant id : " + tenantId + ". " + response);
            }
            if (response.startsWith("__recordCount")) {
                String[] reponseElements = response.split(":");
                if (reponseElements.length == 2) {
                    return Long.parseLong(reponseElements[1]);
                }
                throw new AnalyticsServiceException("Invalid response returned, cannot find record count message. Response:" + response);
            }
            throw new AnalyticsServiceException("Invalid response returned, record count message not found!" + response);
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public void putRecords(String username, List<Record> records, boolean securityEnabled) throws AnalyticsServiceException {
        block8: {
            URIBuilder builder = new URIBuilder();
            builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordProcessor").addParameter("__operation", "__put_records_opr").addParameter("enableSecurity", String.valueOf(securityEnabled));
            if (securityEnabled) {
                builder.addParameter("username", username);
            }
            try {
                HttpPost postMethod = new HttpPost(builder.build().toString());
                postMethod.addHeader("__sessionId", this.sessionId);
                postMethod.setEntity((HttpEntity)new ByteArrayEntity(GenericUtils.serializeObject(records)));
                CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
                if (httpResponse.getStatusLine().getStatusCode() == 401) {
                    String response = this.getResponseString((HttpResponse)httpResponse);
                    throw new AnalyticsServiceUnauthorizedException("Unable to put the records. " + response);
                }
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    String response = this.getResponseString((HttpResponse)httpResponse);
                    throw new AnalyticsServiceException("Unable to put the records. " + response);
                }
                Object recordIdsObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                if (recordIdsObj != null && recordIdsObj instanceof List) {
                    List recordIds = (List)recordIdsObj;
                    int index = 0;
                    for (Record record : records) {
                        record.setId((String)recordIds.get(index));
                        ++index;
                    }
                    break block8;
                }
                throw new AnalyticsServiceException(this.getUnexpectedResponseReturnedErrorMsg("putting the records", null, "list of strings", recordIdsObj));
            }
            catch (URISyntaxException e) {
                throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
            }
        }
    }

    public void deleteRecords(int tenantId, String username, String tableName, long timeFrom, long timeTo, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordProcessor").addParameter("__operation", "__delete_records_range_opr").addParameter("table_name", tableName).addParameter("timeFrom", String.valueOf(timeFrom)).addParameter("timeTo", String.valueOf(timeTo)).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpDelete deleteMethod = new HttpDelete(builder.build().toString());
            deleteMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)deleteMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Unable to delete the record count for the table - " + tableName + ", time from : " + timeFrom + " , timeTo : " + timeTo + " for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Unable to delete the record count for the table - " + tableName + ", time from : " + timeFrom + " , timeTo : " + timeTo + " for tenant id : " + tenantId + ". " + response);
            }
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public void deleteRecords(int tenantId, String username, String tableName, List<String> recordIds, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordProcessor").addParameter("__operation", "__delete_records_ids_opr").addParameter("table_name", tableName).addParameter("recordIds", this.gson.toJson(recordIds)).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpDelete deleteMethod = new HttpDelete(builder.build().toString());
            deleteMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)deleteMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Unable to delete the record count for the table - " + tableName + ", records - " + recordIds + " for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Unable to delete the record count for the table - " + tableName + ", records - " + recordIds + " for tenant id : " + tenantId + ". " + response);
            }
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    private String getUnexpectedResponseReturnedErrorMsg(String operationName, String tableName, String expectedResult, Object foundObj) {
        StringBuilder errorMsgBuilder = new StringBuilder();
        errorMsgBuilder.append("Unexpected response returned from remote analytics service when trying the get the ");
        errorMsgBuilder.append(operationName);
        if (tableName != null) {
            errorMsgBuilder.append(" for table : ");
            errorMsgBuilder.append(tableName);
        } else {
            errorMsgBuilder.append(". ");
        }
        errorMsgBuilder.append("Expected type : ");
        errorMsgBuilder.append(expectedResult);
        errorMsgBuilder.append("but found : ");
        if (foundObj == null) {
            errorMsgBuilder.append("NULL.");
        } else {
            errorMsgBuilder.append(foundObj.getClass().getCanonicalName());
        }
        return errorMsgBuilder.toString();
    }

    public void clearIndices(int tenantId, String username, String tableName, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsIndexProcessor").addParameter("__operation", "__delete_indices_opr").addParameter("table_name", tableName).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpDelete deleteMethod = new HttpDelete(builder.build().toString());
            deleteMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)deleteMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to get the index for table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to get the index for table - " + tableName + " for tenant id : " + tenantId + ". " + response);
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public List<SearchResultEntry> search(int tenantId, String username, String tableName, String query, int start, int count, List<SortByField> sortByFields, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsSearchProcessor").addParameter("__operation", "__search_opr").addParameter("table_name", tableName).addParameter("query", query).addParameter("start", String.valueOf(start)).addParameter("count", String.valueOf(count)).addParameter("sortByFields", this.gson.toJson(sortByFields)).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to search the table - " + tableName + " for tenant id : " + tenantId + " with query : " + query + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to search the table - " + tableName + " for tenant id : " + tenantId + " with query : " + query + ". " + response);
            }
            Object searchResultObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (searchResultObj != null && searchResultObj instanceof List) {
                return (List)searchResultObj;
            }
            throw new AnalyticsServiceException(this.getUnexpectedResponseReturnedErrorMsg("searching the table", tableName, "List of Search Result Entry objects", searchResultObj));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public int searchCount(int tenantId, String username, String tableName, String query, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsSearchProcessor").addParameter("__operation", "__search_count_opr").addParameter("table_name", tableName).addParameter("query", query).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Unable to search the table - " + tableName + " for tenant id : " + tenantId + " with query : " + query + ". " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Unable to search the table - " + tableName + " for tenant id : " + tenantId + " with query : " + query + ". " + response);
            }
            if (response.startsWith("__searchCount")) {
                String[] responseElements = response.split(":");
                if (responseElements.length == 2) {
                    return Integer.parseInt(responseElements[1]);
                }
                throw new AnalyticsServiceException("Invalid response returned, cannot find search count message. Response:" + response);
            }
            throw new AnalyticsServiceException("Invalid response returned, search count message not found!" + response);
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public void waitForIndexing(int tenantId, String username, String tableName, long maxWait, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsIndexProcessor");
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("__operation", "__wait_for_index_opr"));
            params.add(new BasicNameValuePair("maxWait", String.valueOf(maxWait)));
            params.add(new BasicNameValuePair("table_name", tableName));
            params.add(new BasicNameValuePair("tenant_id", String.valueOf(tenantId)));
            params.add(new BasicNameValuePair("username", username));
            params.add(new BasicNameValuePair("enableSecurity", String.valueOf(securityEnabled)));
            postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Unable to configure max wait: " + maxWait + " for indexing. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Unable to configure max wait: " + maxWait + " for indexing. " + response);
            }
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public void destroy() throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsServiceProcessor");
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("__operation", "__destroy_opr"));
            postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Unable to destroy the process . " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Unable to destroy the process . " + response);
            }
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public AnalyticsDataResponse getRecordGroup(int tenantId, String username, String tableName, int numPartitionsHint, List<String> columns, long timeFrom, long timeTo, int recordsFrom, int recordsCount, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordReadProcessor").addParameter("__operation", "__get_range_record_group_opr").addParameter("table_name", tableName).addParameter("partitionerNo", String.valueOf(numPartitionsHint)).addParameter("columns", new Gson().toJson(columns)).addParameter("timeFrom", String.valueOf(timeFrom)).addParameter("timeTo", String.valueOf(timeTo)).addParameter("recordFrom", String.valueOf(recordsFrom)).addParameter("count", String.valueOf(recordsCount)).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to destroy the process . " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to destroy the process . " + response);
            }
            Object analyticsDataResponseObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (analyticsDataResponseObj != null && analyticsDataResponseObj instanceof AnalyticsDataResponse) {
                return (AnalyticsDataResponse)analyticsDataResponseObj;
            }
            throw new AnalyticsServiceAuthenticationException(this.getUnexpectedResponseReturnedErrorMsg("getting the record group", tableName, "Analytics Data Response object", analyticsDataResponseObj));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public AnalyticsDataResponse getWithKeyValues(int tenantId, String username, String tableName, int numPartitionsHint, List<String> columns, List<Map<String, Object>> valuesBatch, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordReadProcessor").addParameter("__operation", "__get_records_with_key_values_opr").addParameter("table_name", tableName).addParameter("partitionerNo", String.valueOf(numPartitionsHint)).addParameter("columns", new Gson().toJson(columns)).addParameter("keyValues", new Gson().toJson(valuesBatch)).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to get with key values . " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to get with key values . " + response);
            }
            Object analyticsDataResponseObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (analyticsDataResponseObj != null && analyticsDataResponseObj instanceof AnalyticsDataResponse) {
                return (AnalyticsDataResponse)analyticsDataResponseObj;
            }
            throw new AnalyticsServiceAuthenticationException(this.getUnexpectedResponseReturnedErrorMsg("getting with key value", tableName, "Analytics Data Response object", analyticsDataResponseObj));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public String getRecordStoreNameByTable(int tenantId, String username, String tableName, boolean securityEnabled) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordStoreProcessor").addParameter("__operation", "__get_record_store_opr").addParameter("table_name", tableName).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Unable to get the record store for the table : " + tableName + " ." + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Unable to get the record store for the table : " + tableName + " ." + response);
            }
            if (response.startsWith("__recordStoreName")) {
                String[] reponseElements = response.split(":");
                if (reponseElements.length == 2) {
                    return reponseElements[1].trim();
                }
                throw new AnalyticsServiceException("Invalid response returned, cannot find record store name message. Response:" + response);
            }
            throw new AnalyticsServiceException("Invalid response returned, record store name message not found!" + response);
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public List<String> listRecordStoreNames() {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordStoreProcessor").addParameter("__operation", "__list_record_stores_opr");
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to list the record stores." + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to list the record stores." + response);
            }
            Object listOfRecordStores = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (listOfRecordStores != null && listOfRecordStores instanceof List) {
                return (List)listOfRecordStores;
            }
            throw new AnalyticsServiceException(this.getUnexpectedResponseReturnedErrorMsg("getting list of record stores", null, "list of record store", listOfRecordStores));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public AnalyticsDataResponse getRecordGroup(int tenantId, String username, String tableName, int numPartitionsHint, List<String> columns, List<String> ids, boolean securityEnabled) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        Gson gson = new Gson();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordReadProcessor").addParameter("__operation", "__get_ids_record_group_opr").addParameter("table_name", tableName).addParameter("partitionerNo", String.valueOf(numPartitionsHint)).addParameter("columns", gson.toJson(columns)).addParameter("recordIds", gson.toJson(ids)).addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to destroy the process . " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to destroy the process . " + response);
            }
            Object analyticsDataResponseObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (analyticsDataResponseObj != null && analyticsDataResponseObj instanceof AnalyticsDataResponse) {
                return (AnalyticsDataResponse)analyticsDataResponseObj;
            }
            throw new AnalyticsServiceAuthenticationException(this.getUnexpectedResponseReturnedErrorMsg("getting the record group", tableName, "Analytics Data Response object", analyticsDataResponseObj));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public AnalyticsIterator<Record> readRecords(String recordStoreName, RecordGroup recordGroup) throws AnalyticsServiceException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsRecordReadProcessor").addParameter("__operation", "__readRecord_opr").addParameter("record_store_name", recordStoreName);
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            postMethod.setEntity((HttpEntity)new ByteArrayEntity(GenericUtils.serializeObject((Object)recordGroup)));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to read the record group. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to read the record group. " + response);
            }
            return new RemoteRecordIterator(httpResponse.getEntity().getContent());
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceAuthenticationException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceAuthenticationException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public boolean isPaginationSupported(String recordStoreName) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsManagementProcessor").setParameter("__operation", "__is_pagination_supported_opr").addParameter("record_store_name", recordStoreName);
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Error while checking the pagination support. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Error while checking the pagination support. " + response);
            }
            if (response.startsWith("__paginationSupport")) {
                String[] reponseElements = response.split(":");
                if (reponseElements.length == 2) {
                    return Boolean.parseBoolean(reponseElements[1]);
                }
                throw new AnalyticsServiceAuthenticationException("Invalid response returned, cannot find pagination support element. Response:" + response);
            }
            throw new AnalyticsServiceAuthenticationException("Invalid response returned, no pagination support found!" + response);
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceException("Malformed URL provided for pagination support checking. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public boolean isRecordCountSupported(String recordStoreName) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsManagementProcessor").setParameter("__operation", "__is_record_count_supported_opr").addParameter("record_store_name", recordStoreName);
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            String response = this.getResponseString((HttpResponse)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                throw new AnalyticsServiceUnauthorizedException("Error while checking the record count support. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new AnalyticsServiceException("Error while checking the record count support. " + response);
            }
            if (response.startsWith("__recordCountSupport")) {
                String[] reponseElements = response.split(":");
                if (reponseElements.length == 2) {
                    return Boolean.parseBoolean(reponseElements[1]);
                }
                throw new AnalyticsServiceAuthenticationException("Invalid response returned, cannot find record count support element. Response:" + response);
            }
            throw new AnalyticsServiceAuthenticationException("Invalid response returned, no record count support found!" + response);
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceException("Malformed URL provided for record count support checking. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public List<SearchResultEntry> drillDownSearch(int tenantId, String username, AnalyticsDrillDownRequest drillDownRequest, boolean securityEnabled) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsSearchProcessor").addParameter("__operation", "__drillDownSearch_opr").addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            postMethod.setEntity((HttpEntity)new ByteArrayEntity(GenericUtils.serializeObject((Object)drillDownRequest)));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to process the DrillDown Request. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to process the DrillDown Request. " + response);
            }
            Object searchResultListObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (searchResultListObj != null && searchResultListObj instanceof List) {
                return (List)searchResultListObj;
            }
            throw new AnalyticsServiceException(this.getUnexpectedResponseReturnedErrorMsg("preforming drill down search", drillDownRequest.getTableName(), "list of search result entry", searchResultListObj));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public double drillDownSearchCount(int tenantId, String username, AnalyticsDrillDownRequest drillDownRequest, boolean securityEnabled) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsSearchProcessor").addParameter("__operation", "drillDownSearchCount_opr").addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            postMethod.setEntity((HttpEntity)new ByteArrayEntity(GenericUtils.serializeObject((Object)drillDownRequest)));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to process the drillDown request. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to process the drillDown request. " + response);
            }
            Object searchCountObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (searchCountObj != null && searchCountObj instanceof Double) {
                return (Double)searchCountObj;
            }
            throw new AnalyticsServiceException(this.getUnexpectedResponseReturnedErrorMsg("preforming drill down search count", drillDownRequest.getTableName(), "number of search result", searchCountObj));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public SubCategories drillDownCategories(int tenantId, String username, CategoryDrillDownRequest drillDownRequest, boolean securityEnabled) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsSearchProcessor").addParameter("__operation", "drillDownSearchCategory_opr").addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            postMethod.setEntity((HttpEntity)new ByteArrayEntity(GenericUtils.serializeObject((Object)drillDownRequest)));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to read the Category drilldown object. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to read the Category drilldown object. " + response);
            }
            Object drillDownCategoriesObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (drillDownCategoriesObj != null && drillDownCategoriesObj instanceof SubCategories) {
                return (SubCategories)drillDownCategoriesObj;
            }
            throw new AnalyticsServiceException(this.getUnexpectedResponseReturnedErrorMsg("preforming drill down search for categories", drillDownRequest.getTableName(), "object of sub categories", drillDownCategoriesObj));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public List<AnalyticsDrillDownRange> drillDownRangeCount(int tenantId, String username, AnalyticsDrillDownRequest drillDownRequest, boolean securityEnabled) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsSearchProcessor").addParameter("__operation", "drillDownRangeCount_opr").addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            postMethod.setEntity((HttpEntity)new ByteArrayEntity(GenericUtils.serializeObject((Object)drillDownRequest)));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Unable to read the Analytics drilldown object. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Unable to read the Analytics drilldown object. " + response);
            }
            Object listOfReangeObj = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (listOfReangeObj != null && listOfReangeObj instanceof List) {
                return (List)listOfReangeObj;
            }
            throw new AnalyticsServiceException(this.getUnexpectedResponseReturnedErrorMsg("preforming drill down range count", drillDownRequest.getTableName(), "list of analytics drill down ranges", listOfReangeObj));
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public AnalyticsIterator<Record> searchWithAggregates(int tenantId, String username, AggregateRequest aggregateRequest, boolean securityEnabled) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsSearchProcessor").addParameter("__operation", "searchWithAggregates_opr").addParameter("enableSecurity", String.valueOf(securityEnabled)).addParameter("groupByField", aggregateRequest.getGroupByField()).addParameter("query", aggregateRequest.getQuery()).addParameter("aggregatingFields", this.gson.toJson((Object)aggregateRequest.getFields())).addParameter("table_name", aggregateRequest.getTableName()).addParameter("aggregateLevel", String.valueOf(aggregateRequest.getAggregateLevel())).addParameter("aggregateParentPath", this.gson.toJson((Object)aggregateRequest.getParentPath())).addParameter("noOfRecords", this.gson.toJson((Object)aggregateRequest.getNoOfRecords()));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Error while searching with aggregates. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Error while searching with aggregates. " + response);
            }
            return new RemoteRecordIterator(httpResponse.getEntity().getContent());
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public List<AnalyticsIterator<Record>> searchWithAggregates(int tenantId, String username, AggregateRequest[] aggregateRequests, boolean securityEnabled) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsSearchProcessor").addParameter("__operation", "searchMultiTablesWithAggregates_opr").addParameter("enableSecurity", String.valueOf(securityEnabled));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpPost postMethod = new HttpPost(builder.build().toString());
            postMethod.addHeader("__sessionId", this.sessionId);
            postMethod.setEntity((HttpEntity)new ByteArrayEntity(GenericUtils.serializeObject((Object)aggregateRequests)));
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)postMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Error while searching with aggregates. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Error while searching with aggregates. " + response);
            }
            Object aggregateObjs = GenericUtils.deserializeObject((InputStream)httpResponse.getEntity().getContent());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (aggregateObjs != null && aggregateObjs instanceof List) {
                List aggregatedRecords = (List)aggregateObjs;
                ArrayList<AnalyticsIterator<Record>> iterators = new ArrayList<AnalyticsIterator<Record>>();
                for (List aggregateRecordsPerTable : aggregatedRecords) {
                    iterators.add(new RecordIterator(aggregateRecordsPerTable));
                }
                return iterators;
            }
            throw new AnalyticsServiceException("Error while reading MultiTable Aggregate response.. (unknown format or null..)");
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    public void reIndex(int tenantId, String username, String tableName, long startTime, long endTime, boolean securityEnabled) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(this.protocol).setHost(this.hostname).setPort(this.port).setPath("/analytics-api/AnalyticsIndexProcessor").addParameter("__operation", "reIndex_opr").addParameter("enableSecurity", String.valueOf(securityEnabled)).addParameter("table_name", tableName).addParameter("timeFrom", String.valueOf(startTime)).addParameter("timeTo", String.valueOf(endTime));
        if (!securityEnabled) {
            builder.addParameter("tenant_id", String.valueOf(tenantId));
        } else {
            builder.addParameter("username", username);
        }
        try {
            HttpGet getMethod = new HttpGet(builder.build().toString());
            getMethod.addHeader("__sessionId", this.sessionId);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            if (httpResponse.getStatusLine().getStatusCode() == 401) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceUnauthorizedException("Error while re-indexing. " + response);
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                String response = this.getResponseString((HttpResponse)httpResponse);
                throw new AnalyticsServiceException("Error while re-indexing. " + response);
            }
        }
        catch (URISyntaxException e) {
            throw new AnalyticsServiceException("Malformed URL provided. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AnalyticsServiceException("Error while connecting to the remote service. " + e.getMessage(), e);
        }
    }

    private static class RecordIterator
    implements AnalyticsIterator<Record> {
        private List<Record> records;
        private Iterator<Record> iterator;

        public RecordIterator(List<Record> records) {
            this.records = records;
        }

        public void close() throws IOException {
        }

        public boolean hasNext() {
            if (this.records == null || this.records.isEmpty()) {
                return false;
            }
            if (this.iterator == null) {
                this.iterator = this.records.iterator();
            }
            return this.iterator.hasNext();
        }

        public Record next() {
            if (this.hasNext()) {
                return this.iterator.next();
            }
            return null;
        }

        public void remove() {
        }
    }
}

