/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.api;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsIterator;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.io.commons.GenericUtils;

public class RemoteRecordIterator
implements AnalyticsIterator<Record> {
    private static final Log log = LogFactory.getLog(RemoteRecordIterator.class);
    private InputStream inputStream;
    private Record nextObject;
    private boolean completed;

    public RemoteRecordIterator(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.completed = false;
    }

    public synchronized boolean hasNext() {
        try {
            if (this.nextObject != null) {
                return true;
            }
            if (!this.completed) {
                try {
                    this.nextObject = (Record)GenericUtils.deserializeObject((InputStream)this.inputStream);
                }
                catch (EOFException ex) {
                    this.cleanup();
                }
            }
            return this.nextObject != null;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while streaming the results: " + e.getMessage(), e);
        }
    }

    public synchronized Record next() {
        if (this.hasNext()) {
            Record currentObj = this.nextObject;
            this.nextObject = null;
            return currentObj;
        }
        return null;
    }

    public void remove() {
        throw new RuntimeException("Cannot remove the records from this iterator");
    }

    private void cleanup() throws IOException {
        this.nextObject = null;
        this.completed = true;
        this.inputStream.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing the HTTP connection created!");
        }
    }

    public void close() throws IOException {
        if (!this.completed) {
            this.cleanup();
        }
    }
}

