/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class RequiredValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private final List<String> fieldNames;

    public RequiredValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.REQUIRED, validationContext);
        if (schemaNode.isArray()) {
            this.fieldNames = new ArrayList<String>(schemaNode.size());
            for (JsonNode fieldNme : schemaNode) {
                this.fieldNames.add(fieldNme.asText());
            }
        } else {
            this.fieldNames = Collections.emptyList();
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        RequiredValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        if (!node.isObject()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ValidationMessage> errors = null;
        for (String fieldName : this.fieldNames) {
            JsonNode readOnlyNode;
            JsonNode writeOnlyNode;
            JsonNode propertyNode = node.get(fieldName);
            if (propertyNode != null) continue;
            Boolean readOnly = this.validationContext.getConfig().getReadOnly();
            Boolean writeOnly = this.validationContext.getConfig().getWriteOnly();
            if (!Boolean.TRUE.equals(readOnly) ? Boolean.TRUE.equals(writeOnly) && (writeOnlyNode = this.getFieldKeyword(fieldName, "writeOnly")) != null && writeOnlyNode.booleanValue() : (readOnlyNode = this.getFieldKeyword(fieldName, "readOnly")) != null && readOnlyNode.booleanValue()) continue;
            if (errors == null) {
                errors = new LinkedHashSet<ValidationMessage>();
            }
            errors.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).property(fieldName)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(fieldName)).build());
        }
        return errors == null ? Collections.emptySet() : Collections.unmodifiableSet(errors);
    }

    protected JsonNode getFieldKeyword(String fieldName, String keyword) {
        JsonNode fieldNode;
        JsonNode propertiesNode = this.parentSchema.getSchemaNode().get("properties");
        if (propertiesNode != null && (fieldNode = propertiesNode.get(fieldName)) != null) {
            return fieldNode.get(keyword);
        }
        return null;
    }
}

