/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentClientInstance;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class ProxyInvocationHandler
implements InvocationHandler {
    private final Map<Method, Interceptor> interceptors;
    private final ComponentView componentView;
    private final ComponentClientInstance instance;

    public ProxyInvocationHandler(Map<Method, Interceptor> interceptors, ComponentClientInstance instance, ComponentView componentView) {
        this.interceptors = interceptors;
        this.instance = instance;
        this.componentView = componentView;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Interceptor interceptor = this.interceptors.get(method);
        if (interceptor == null) {
            throw new NoSuchMethodError(method.toString());
        }
        InterceptorContext context = new InterceptorContext();
        context.putPrivateData(Object.class, proxy);
        context.putPrivateData(Component.class, (Object)this.componentView.getComponent());
        context.putPrivateData(ComponentView.class, (Object)this.componentView);
        context.putPrivateData(SecurityDomain.class, (Object)(WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(SecurityDomain::getCurrent) : SecurityDomain.getCurrent()));
        this.instance.prepareInterceptorContext(context);
        context.setParameters(args);
        context.setMethod(method);
        context.setContextData(new HashMap());
        context.setBlockingCaller(true);
        return interceptor.processInvocation(context);
    }
}

