/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ObjectTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.PropertyConfigurable;

public class PropertyObjectTypeAttributeDefinition
extends ObjectTypeAttributeDefinition
implements ConfigurationProperty<String> {
    private final ModelNodeResolver<String> resolver;
    private final String propertyName;

    private PropertyObjectTypeAttributeDefinition(Builder builder) {
        super((AbstractAttributeDefinitionBuilder)builder, builder.suffix, builder.valueTypes);
        this.propertyName = builder.propertyName;
        this.resolver = builder.resolver;
    }

    @Override
    public ModelNodeResolver<String> resolver() {
        return this.resolver;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String resolvePropertyValue(OperationContext context, ModelNode model) throws OperationFailedException {
        String result = null;
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            result = this.resolver == null ? value.asString() : this.resolver.resolveValue(context, value);
        }
        return result;
    }

    @Override
    public void setPropertyValue(OperationContext context, ModelNode model, PropertyConfigurable configuration) throws OperationFailedException {
        String value = this.resolvePropertyValue(context, model);
        if (value == null) {
            configuration.removeProperty(this.propertyName);
        } else {
            configuration.setPropertyValueString(this.propertyName, value);
        }
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, PropertyObjectTypeAttributeDefinition> {
        private ModelNodeResolver<String> resolver;
        private String propertyName;
        private String suffix;
        private final AttributeDefinition[] valueTypes;

        public Builder(String name, AttributeDefinition ... valueTypes) {
            super(name, ModelType.OBJECT, true);
            this.valueTypes = valueTypes;
        }

        public static Builder of(String name, AttributeDefinition ... valueTypes) {
            return new Builder(name, valueTypes);
        }

        public PropertyObjectTypeAttributeDefinition build() {
            if (this.getValidator() == null) {
                this.setValidator((ParameterValidator)new ObjectTypeValidator(this.isNillable(), this.valueTypes));
            }
            return new PropertyObjectTypeAttributeDefinition(this);
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public Builder setResolver(ModelNodeResolver<String> resolver) {
            this.resolver = resolver;
            return this;
        }
    }
}

