/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingSubsystemParser_1_2;
import org.jboss.as.logging.handlers.SizeRotatingHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class LoggingSubsystemParser_1_3
extends LoggingSubsystemParser_1_2 {
    LoggingSubsystemParser_1_3() {
    }

    @Override
    void parseSizeRotatingHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block16;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case ROTATE_ON_BOOT: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_3.addOperationAddress(operation, address, "size-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block17: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_3.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case FILTER_SPEC: {
                    SizeRotatingHandlerResourceDefinition.FILTER_SPEC.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case FORMATTER: {
                    this.parseHandlerFormatterElement(reader, operation);
                    continue block17;
                }
                case FILE: {
                    this.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block17;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ROTATE_SIZE: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case MAX_BACKUP_INDEX: {
                    SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.parseAndSetParameter(LoggingSubsystemParser_1_3.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }
}

