/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

class CompositeClassLoader
extends ClassLoader {
    private List<ClassLoader> loaders;

    CompositeClassLoader(List<ClassLoader> loaders) {
        super(null);
        this.loaders = loaders;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.findClass(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> results = new ArrayList<Enumeration<URL>>(this.loaders.size());
        for (ClassLoader loader : this.loaders) {
            results.add(loader.getResources(name));
        }
        final Iterator iterator = results.iterator();
        return new Enumeration<URL>(){
            private Enumeration<URL> urls = Collections.emptyEnumeration();

            @Override
            public boolean hasMoreElements() {
                return this.getURLs().hasMoreElements();
            }

            @Override
            public URL nextElement() {
                return this.getURLs().nextElement();
            }

            private Enumeration<URL> getURLs() {
                if (!this.urls.hasMoreElements() && iterator.hasNext()) {
                    this.urls = (Enumeration)iterator.next();
                }
                return this.urls;
            }
        };
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader loader : this.loaders) {
            URL resource = loader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return super.findResource(name);
    }
}

