/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.spi;

import jakarta.batch.operations.JobOperator;
import org.jberet.operations.JobOperatorImpl;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.DefaultJobOperatorContextSelector;
import org.jberet.spi.JobOperatorContextSelector;
import org.jberet.util.Assertions;

public abstract class JobOperatorContext {
    private static volatile JobOperatorContextSelector SELECTOR = null;

    public static JobOperatorContext getJobOperatorContext() {
        JobOperatorContextSelector selector = SELECTOR;
        if (selector == null) {
            selector = DefaultHolder.DEFAULT;
        }
        return selector.getJobOperatorContext();
    }

    public static JobOperatorContext create(BatchEnvironment batchEnvironment) {
        final JobOperatorImpl jobOperator = new JobOperatorImpl(Assertions.notNull(batchEnvironment, "batchEnvironment"));
        return new JobOperatorContext(){

            @Override
            public JobOperator getJobOperator() {
                return jobOperator;
            }
        };
    }

    public static JobOperatorContext create(final JobOperator jobOperator) {
        Assertions.notNull(jobOperator, "jobOperator");
        return new JobOperatorContext(){

            @Override
            public JobOperator getJobOperator() {
                return jobOperator;
            }
        };
    }

    public static void setJobOperatorContextSelector(JobOperatorContextSelector selector) {
        SELECTOR = selector;
    }

    public abstract JobOperator getJobOperator();

    private static class DefaultHolder {
        static final JobOperatorContextSelector DEFAULT = new DefaultJobOperatorContextSelector();

        private DefaultHolder() {
        }
    }
}

