/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.impl;

import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionCollector;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionContributor;

public final class LuceneAnalysisDefinitionRegistry {
    private final Similarity similarity;
    private final Map<String, Analyzer> analyzerDefinitions;
    private final Map<String, Analyzer> normalizerDefinitions;

    public LuceneAnalysisDefinitionRegistry(LuceneAnalysisDefinitionContributor contributor) {
        this.similarity = contributor.getSimilarity().orElseGet(LuceneAnalysisDefinitionRegistry::createDefaultSimilarity);
        this.analyzerDefinitions = new TreeMap<String, Analyzer>();
        this.normalizerDefinitions = new TreeMap<String, Analyzer>();
        contributor.contribute(new LuceneAnalysisDefinitionCollector(){

            @Override
            public void collectAnalyzer(String name, Analyzer analyzer) {
                LuceneAnalysisDefinitionRegistry.this.analyzerDefinitions.put(name, analyzer);
            }

            @Override
            public void collectNormalizer(String name, Analyzer normalizer) {
                LuceneAnalysisDefinitionRegistry.this.normalizerDefinitions.put(name, normalizer);
            }
        });
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public Analyzer getAnalyzerDefinition(String name) {
        return this.analyzerDefinitions.get(name);
    }

    public Analyzer getNormalizerDefinition(String name) {
        return this.normalizerDefinitions.get(name);
    }

    private static Similarity createDefaultSimilarity() {
        return new BM25Similarity();
    }
}

