/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.function.Consumer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.Assert;

class TrivialService<T>
implements Service<T>,
org.jboss.msc.Service {
    private volatile ValueSupplier<T> valueSupplier;
    private final Consumer<T> valueConsumer;
    private volatile T value;

    TrivialService() {
        this.valueConsumer = null;
    }

    TrivialService(ValueSupplier<T> valueSupplier, Consumer<T> valueConsumer) {
        this.valueSupplier = (ValueSupplier)Assert.checkNotNullParam((String)"valueSupplier", valueSupplier);
        this.valueConsumer = valueConsumer;
    }

    TrivialService(ValueSupplier<T> valueSupplier) {
        this(valueSupplier, null);
    }

    void setValueSupplier(ValueSupplier<T> valueSupplier) {
        this.valueSupplier = (ValueSupplier)Assert.checkNotNullParam((String)"valueSupplier", valueSupplier);
    }

    public void start(StartContext context) throws StartException {
        this.value = ((ValueSupplier)Assert.checkNotNullParam((String)"valueSupplier", this.valueSupplier)).get();
        if (this.valueConsumer != null) {
            this.valueConsumer.accept(this.value);
        }
    }

    public void stop(StopContext context) {
        this.valueSupplier.dispose();
        this.value = null;
    }

    public T getValue() throws IllegalStateException, IllegalArgumentException {
        return this.value;
    }

    @FunctionalInterface
    static interface ValueSupplier<T> {
        public T get() throws StartException;

        default public void dispose() {
        }
    }
}

