/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry.api;

import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import io.smallrye.opentelemetry.implementation.rest.OpenTelemetryClientFilter;
import io.smallrye.opentelemetry.implementation.rest.OpenTelemetryServerFilter;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;

public final class OpenTelemetryCdiExtension
implements Extension {
    private final boolean useServerConfig;
    private final Map<String, String> config;

    public OpenTelemetryCdiExtension(boolean useServerConfig, Map<String, String> config) {
        this.useServerConfig = useServerConfig;
        this.config = config;
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(OpenTelemetryServerFilter.class), OpenTelemetryServerFilter.class.getName());
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(OpenTelemetryClientFilter.class), OpenTelemetryClientFilter.class.getName());
    }

    public void registerOpenTelemetryConfigBean(@Observes AfterBeanDiscovery abd) {
        if (this.useServerConfig) {
            abd.addBean().scope(Singleton.class).addQualifier((Annotation)Default.Literal.INSTANCE).types(new Type[]{OpenTelemetryConfig.class}).createWith(e -> () -> this.config);
        }
    }
}

