/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.FallbackConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

public final class FallbackConfigImpl
implements FallbackConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Fallback instance;
    private final boolean onMethod;
    private Class<? extends FallbackHandler<?>> _value;
    private String _fallbackMethod;
    private Class<? extends Throwable>[] _applyOn;
    private Class<? extends Throwable>[] _skipOn;

    private FallbackConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.fallback;
        this.onMethod = method.annotationsPresentDirectly.contains(Fallback.class);
    }

    public static FallbackConfigImpl create(FaultToleranceMethod method) {
        if (method.fallback == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(Fallback.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new FallbackConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Fallback.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<? extends FallbackHandler<?>> value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Fallback/value";
                this._value = config.getOptionalValue(key, Class.class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Fallback/value";
                this._value = config.getOptionalValue(key, Class.class).orElse(null);
            }
            if (this._value == null) {
                this._value = config.getOptionalValue("Fallback/value", Class.class).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public String fallbackMethod() {
        if (this._fallbackMethod == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Fallback/fallbackMethod";
                this._fallbackMethod = config.getOptionalValue(key, String.class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Fallback/fallbackMethod";
                this._fallbackMethod = config.getOptionalValue(key, String.class).orElse(null);
            }
            if (this._fallbackMethod == null) {
                this._fallbackMethod = config.getOptionalValue("Fallback/fallbackMethod", String.class).orElse(null);
            }
            if (this._fallbackMethod == null) {
                this._fallbackMethod = this.instance.fallbackMethod();
            }
        }
        return this._fallbackMethod;
    }

    public Class<? extends Throwable>[] applyOn() {
        if (this._applyOn == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Fallback/applyOn";
                this._applyOn = config.getOptionalValue(key, Class[].class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Fallback/applyOn";
                this._applyOn = config.getOptionalValue(key, Class[].class).orElse(null);
            }
            if (this._applyOn == null) {
                this._applyOn = config.getOptionalValue("Fallback/applyOn", Class[].class).orElse(null);
            }
            if (this._applyOn == null) {
                this._applyOn = this.instance.applyOn();
            }
        }
        return this._applyOn;
    }

    public Class<? extends Throwable>[] skipOn() {
        if (this._skipOn == null) {
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                String key = this.method.declaringClass.getName() + "/" + this.method.name + "/Fallback/skipOn";
                this._skipOn = config.getOptionalValue(key, Class[].class).orElse(null);
            } else {
                String key = this.method.declaringClass.getName() + "/Fallback/skipOn";
                this._skipOn = config.getOptionalValue(key, Class[].class).orElse(null);
            }
            if (this._skipOn == null) {
                this._skipOn = config.getOptionalValue("Fallback/skipOn", Class[].class).orElse(null);
            }
            if (this._skipOn == null) {
                this._skipOn = this.instance.skipOn();
            }
        }
        return this._skipOn;
    }

    public void materialize() {
        this.value();
        this.fallbackMethod();
        this.applyOn();
        this.skipOn();
    }
}

